------Alter CRS Stored Procedures
---RTC  Work Item 645294  - Update UI Stored Procedures to Display either Zip or PostalCode from SPATIENT table [o]

--crs.usp_CDW_SaveData
--crs.usp_PATIENT_getitemComplete
--crs.usp_PATIENT_getitemsByName
--crs.usp_REFERRAL_getitemComplete
--crs.usp_REFERRAL_getitemsByPatient
--crs.usp_REFERRAL_getitemsByProvider
--crs.usp_REFERRAL_getitemsByRegistryStatus
--crs.usp_REFERRAL_getitemsByRegistryStatus_optimized
--crs.usp_REFERRAL_getitemsByRegistryStatus_optimized2
--crs.usp_REFERRAL_getitemsCommonByRegistry
--crs.usp_REFERRAL_getitemsCommonByRegistry_optomized
--crs.usp_SPATIENT_save

USE CRS
GO

-- =============================================
-- Author:        
-- Create date:   03/01/2016
-- Description:   Save/Update Patient, SPatient, and Referral
---               Updated Stored Procedure to Display either Zip or PostalCode from SPATIENT table.
-- =============================================
ALTER PROCEDURE [CRS].[usp_CDW_SaveData] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @AddressChangeInstitutionIEN varchar(50), @AddressChangeInstitutionSID int, @AddressChangeStaffIEN varchar(50), @AddressChangeStaffSID int, @Age numeric(18,0),
 @BadAddressIndicator varchar(50), @CDDeterminingInstitutionIEN varchar(50), @City varchar(50), @CombatFromVistaDate varchar(50), @CombatToVistaDate varchar(50), @ConfidentialAddressActiveFlag char(1), @Country varchar(100), @CountryIEN varchar(50), @CountrySID int, @County varchar(50), @Created datetime, @CreatedBy varchar(30), @CurrentMeansTestStatusIEN varchar(50), @DateOfBirth date, @DateOfBirthText varchar(50), @DateOfDeath date, @DateOfDeathText varchar(50), @Deceased char(1), @DEFAULT_RECORD bit, @Eligibility varchar(50), @EligibilityIEN varchar(50), @EligibilitySID int, @EligibilityStatus varchar(50), @EligibilityVACode numeric(18,0), @EligibilityVerificationSource varchar(50), @EmailAddress varchar(50), @EnteredIntoFileDate date, @EnteredIntoFileDateTransformSID bigint, @EnteredIntoFileVistaErrorDate varchar(50), @ETLBatchID int, @ExcludeFromFacilityDirectoryFlag char(1), @Gender char(1), @GISAddressType varchar(50), @GISAddressUpdatedDate date, @GISCongressDistrict varchar(50), @GISFIPSCode varchar(50), @GISLocatorName varchar(50), @GISMarket varchar(50), @GISMatchedAddress varchar(50), @GISMatchMethodCode varchar(50), @GISMatchScore int, @GISMatchStatusCode varchar(50), @GISPatientAddressLatitude float, @GISPatientAddressLongitude float, @GISSector varchar(50), @GISStreetSide varchar(50), @GISSubmarket varchar(50), @GISURH char(1), @InsuranceCoverageFlag char(1), @LastServiceEntryDate date, @LastServiceEntryDateTransformSID bigint, @LastServiceEntryVistaErrorDate varchar(50), @LastServiceSeparationDate date, @LastServiceSeparationDateTransformSID bigint, @LastServiceSeparationVistaErrorDate varchar(50), @MaritalStatus varchar(25), @MaritalStatusIEN varchar(50), @MaritalStatusSID int, @MedicaidNumber varchar(50), @MothersMaidenName varchar(50), 
@OEF_OIF_IND bit, @OpCode char(1), @Patient_ID int, @PatientFirstName varchar(50), @PatientICN varchar(50), @PatientICNChecksum varchar(50), @PatientIEN varchar(50), @PatientLastName varchar(50), @PatientName varchar(100), @PatientSID int, @PatientSSN varchar(50), @PercentServiceConnect int, @PeriodOfService varchar(50), @PeriodOfServiceIEN varchar(50), @PeriodOfServiceSID int, @PhoneCellular varchar(50), @PhoneResidence varchar(50), @PhoneWork varchar(50), @PK_ID int output, @PostalCode varchar(50), @POWLocationIEN varchar(50), @PreferredInstitutionIEN varchar(50), @Province varchar(50), @PseudoSSNFlag char(1), @PurpleHeartInstitutionIEN varchar(50), @Race varchar(45), @RaceIEN varchar(50), @RaceSID int, @Religion varchar(30), @ReligionIEN varchar(50), @ReligionSID int, @RoomBedIEN varchar(50), @ScrSSN varchar(50), @SensitiveFlag char(1), @Sta3n smallint, @State varchar(30), @StateIEN varchar(50), @StateSID int, @STD_COMBATLOCATION_ID int, @STD_ENTHNICITY_ID int, @STD_GENDER_ID int, @STD_MARITALSTATUS_ID
 int, @STD_RACE_ID int, @STD_SERVICEBRANCH_ID int, @StdRegistryId int, @StreetAddress1 varchar(50), @StreetAddress2 varchar(50), @StreetAddress3 varchar(50), @TemporaryAddressChangeInstitutionIEN varchar(50), @Updatedate datetime, @UpdatedBy varchar(30), 
@VeteranFlag char(1), @VistaCreateDate datetime, @VistaEditDate datetime, @Zip varchar(50), @Zip4 varchar(50))
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);
	SET @Created = GETDATE();
	SET @Updatedate = GETDATE();
	SET @PostalCode = ISNULL(@PostalCode,@Zip) 
	SET @Zip = ISNULL(@Zip,@PostalCode)

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.CDW_SaveData', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	EXECUTE [CRS].[usp_PATIENT_saveBySID] 
		@CURRENT_USER = @CURRENT_USER
		,@CURRENT_REGISTRY_ID = @CURRENT_REGISTRY_ID
		,@PATIENT_ID = @PATIENT_ID OUTPUT
		,@FIRST_NAME = @PatientFirstName
		,@MIDDLE_NAME = NULL
		,@LAST_NAME = @PatientLastName
		,@EMAIL_ADDRESS = @EmailAddress
		,@BIRTH_DATE = @DateOfBirth
		,@DEATH_DATE = @DateOfDeath
		,@CELL_PHONE = NULL
		,@PERFERRED_ADDRESS_TYPE = NULL
		,@CREATEDBY = @CURRENT_USER
		,@CREATED = @Created
		,@UPDATEDBY = @CURRENT_USER
		,@UPDATED = @Updatedate
		,@OEFOIF_IND = @OEF_OIF_IND
		,@PATIENTSID = @PatientSID;

	IF (@Patient_ID > 0)
	BEGIN

		EXECUTE [CRS].[usp_SPATIENT_save] 
		   @CURRENT_USER = @CURRENT_USER
		  ,@CURRENT_REGISTRY_ID = @CURRENT_REGISTRY_ID
		  ,@AddressChangeInstitutionIEN = @AddressChangeInstitutionIEN
		  ,@AddressChangeInstitutionSID = @AddressChangeInstitutionSID
		  ,@AddressChangeStaffIEN = @AddressChangeStaffIEN
		  ,@AddressChangeStaffSID = @AddressChangeStaffSID
		  ,@Age = @Age
		  ,@BadAddressIndicator = @BadAddressIndicator
		  ,@CDDeterminingInstitutionIEN = @CDDeterminingInstitutionIEN
		  ,@City = @City
		  ,@CombatFromVistaDate = @CombatFromVistaDate
		  ,@CombatToVistaDate = @CombatToVistaDate
		  ,@ConfidentialAddressActiveFlag = @ConfidentialAddressActiveFlag
		  ,@Country = @Country
		  ,@CountryIEN = @CountryIEN
		  ,@CountrySID = @CountrySID
		  ,@County = @County
		  ,@Created = @Created
		  ,@CreatedBy = @CURRENT_USER
		  ,@CurrentMeansTestStatusIEN = @CurrentMeansTestStatusIEN
		  ,@DateOfBirth = @DateOfBirth
		  ,@DateOfBirthText = @DateOfBirthText
		  ,@DateOfDeath = @DateOfDeath
		  ,@DateOfDeathText = @DateOfDeathText
		  ,@Deceased = @Deceased
		  ,@DEFAULT_RECORD = @DEFAULT_RECORD
		  ,@Eligibility = @Eligibility
		  ,@EligibilityIEN = @EligibilityIEN
		  ,@EligibilitySID = @EligibilitySID
		  ,@EligibilityStatus = @EligibilityStatus
		  ,@EligibilityVACode = @EligibilityVACode
		  ,@EligibilityVerificationSource = @EligibilityVerificationSource
		  ,@EmailAddress = @EmailAddress
		  ,@EnteredIntoFileDate = @EnteredIntoFileDate
		  ,@EnteredIntoFileDateTransformSID = @EnteredIntoFileDateTransformSID
		  ,@EnteredIntoFileVistaErrorDate = @EnteredIntoFileVistaErrorDate
		  ,@ETLBatchID = @ETLBatchID
		  ,@ExcludeFromFacilityDirectoryFlag = @ExcludeFromFacilityDirectoryFlag
		  ,@Gender = @Gender
		  ,@GISAddressType = @GISAddressType
		  ,@GISAddressUpdatedDate = @GISAddressUpdatedDate
		  ,@GISCongressDistrict = @GISCongressDistrict
		  ,@GISFIPSCode = @GISFIPSCode
		  ,@GISLocatorName = @GISLocatorName
		  ,@GISMarket = @GISMarket
		  ,@GISMatchedAddress = @GISMatchedAddress
		  ,@GISMatchMethodCode = @GISMatchMethodCode
		  ,@GISMatchScore = @GISMatchScore
		  ,@GISMatchStatusCode = @GISMatchStatusCode
		  ,@GISPatientAddressLatitude = @GISPatientAddressLatitude
		  ,@GISPatientAddressLongitude = @GISPatientAddressLongitude
		  ,@GISSector = @GISSector
		  ,@GISStreetSide = @GISStreetSide
		  ,@GISSubmarket = @GISSubmarket
		  ,@GISURH = @GISURH
		  ,@InsuranceCoverageFlag = @InsuranceCoverageFlag
		  ,@LastServiceEntryDate = @LastServiceEntryDate
		  ,@LastServiceEntryDateTransformSID = @LastServiceEntryDateTransformSID
		  ,@LastServiceEntryVistaErrorDate = @LastServiceEntryVistaErrorDate
		  ,@LastServiceSeparationDate = @LastServiceSeparationDate
		  ,@LastServiceSeparationDateTransformSID = @LastServiceSeparationDateTransformSID
		  ,@LastServiceSeparationVistaErrorDate = @LastServiceSeparationVistaErrorDate
		  ,@MaritalStatus = @MaritalStatus
		  ,@MaritalStatusIEN = @MaritalStatusIEN
		  ,@MaritalStatusSID = @MaritalStatusSID
		  ,@MedicaidNumber = @MedicaidNumber
		  ,@MothersMaidenName = @MothersMaidenName
		  ,@OEF_OIF_IND = @OEF_OIF_IND
		  ,@OpCode = @OpCode
		  ,@Patient_ID = @Patient_ID
		  ,@PatientFirstName = @PatientFirstName
		  ,@PatientICN = @PatientICN
		  ,@PatientICNChecksum = @PatientICNChecksum
		  ,@PatientIEN = @PatientIEN
		  ,@PatientLastName = @PatientLastName
		  ,@PatientName = @PatientName
		  ,@PatientSID = @PatientSID
		  ,@PatientSSN = @PatientSSN
		  ,@PercentServiceConnect = @PercentServiceConnect
		  ,@PeriodOfService = @PeriodOfService
		  ,@PeriodOfServiceIEN = @PeriodOfServiceIEN
		  ,@PeriodOfServiceSID = @PeriodOfServiceSID
		  ,@PhoneCellular = @PhoneCellular
		  ,@PhoneResidence = @PhoneResidence
		  ,@PhoneWork = @PhoneWork
		  ,@PK_ID = @PK_ID
		  ,@PostalCode = @PostalCode
		  ,@POWLocationIEN = @POWLocationIEN
		  ,@PreferredInstitutionIEN = @PreferredInstitutionIEN
		  ,@Province = @Province
		  ,@PseudoSSNFlag = @PseudoSSNFlag
		  ,@PurpleHeartInstitutionIEN = @PurpleHeartInstitutionIEN
		  ,@Race = @Race
		  ,@RaceIEN = @RaceIEN
		  ,@RaceSID = @RaceSID
		  ,@Religion = @Religion
		  ,@ReligionIEN = @ReligionIEN
		  ,@ReligionSID = @ReligionSID
		  ,@RoomBedIEN = @RoomBedIEN
		  ,@ScrSSN = @ScrSSN
		  ,@SensitiveFlag = @SensitiveFlag
		  ,@Sta3n = @Sta3n
		  ,@State = @State
		  ,@StateIEN = @StateIEN
		  ,@StateSID = @StateSID
		  ,@STD_COMBATLOCATION_ID = @STD_COMBATLOCATION_ID
		  ,@STD_ENTHNICITY_ID = @STD_ENTHNICITY_ID
		  ,@STD_GENDER_ID = @STD_GENDER_ID
		  ,@STD_MARITALSTATUS_ID = @STD_MARITALSTATUS_ID
		  ,@STD_RACE_ID = @STD_RACE_ID
		  ,@STD_SERVICEBRANCH_ID = @STD_SERVICEBRANCH_ID
		  ,@StdRegistryId = @StdRegistryId
		  ,@StreetAddress1 = @StreetAddress1
		  ,@StreetAddress2 = @StreetAddress2
		  ,@StreetAddress3 = @StreetAddress3
		  ,@TemporaryAddressChangeInstitutionIEN = @TemporaryAddressChangeInstitutionIEN
		  ,@Updatedate = @Updatedate
		  ,@UpdatedBy = @CURRENT_USER
		  ,@VeteranFlag = @VeteranFlag
		  ,@VistaCreateDate = @VistaCreateDate
		  ,@VistaEditDate = @VistaEditDate
		  ,@Zip = @Zip
		  ,@Zip4 = @Zip4;

		EXECUTE [CRS].[usp_REFERRAL_saveByPatientRegistry] 
			@CURRENT_USER = @CURRENT_USER
			, @CURRENT_REGISTRY_ID = @CURRENT_REGISTRY_ID
			, @COMMENT_TEXT = NULL
			, @CREATED = @Created
			, @CREATEDBY = @CURRENT_USER
			, @CREATEDSOURCE = 'CDW'
			, @DUPLICATE_FLAG = 0
			, @PATIENT_ID = @PATIENT_ID
			, @PROVIDER_ID = NULL
			, @REFERRAL_CLASS_TEXT = NULL
			, @REFERRAL_DATE = @Updatedate
			, @REFERRAL_ID = NULL
			, @REVIEW_BY = NULL
			, @REVIEW_DATE = NULL
			, @STD_REFERRALSTS_ID = 1 --TODO
			, @STD_REGISTRY_ID = @CURRENT_REGISTRY_ID
			, @STD_REMINDERCLASS_ID = NULL
			, @UPDATED = @Updatedate
			, @UPDATEDBY = @CURRENT_USER
			, @UPDATEDSOURCE = 'CDW';
	END
END

GO


-- =============================================
-- Author:        
-- Create date:   12/15/2015
-- Description:   Get record by ID
---               Updated Stored Procedure to Display either Zip or PostalCode from SPATIENT table.
-- =============================================
ALTER PROCEDURE [CRS].[usp_PATIENT_getitemComplete] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @PATIENT_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_PATIENT_getitemComplete', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[PATIENT].[BIRTH_DATE] AS [PATIENT_BIRTH_DATE]
		,[CRS].[PATIENT].[CELL_PHONE] AS [PATIENT_CELL_PHONE]
		,[CRS].[PATIENT].[CREATED] AS [PATIENT_CREATED]
		,[CRS].[PATIENT].[CREATEDBY] AS [PATIENT_CREATEDBY]
		,[CRS].[PATIENT].[DEATH_DATE] AS [PATIENT_DEATH_DATE]
		,[CRS].[PATIENT].[EMAIL_ADDRESS] AS [PATIENT_EMAIL_ADDRESS]
		,[CRS].[PATIENT].[FIRST_NAME] AS [PATIENT_FIRST_NAME]
		,[CRS].[PATIENT].[LAST_NAME] AS [PATIENT_LAST_NAME]
		,[CRS].[PATIENT].[MIDDLE_NAME] AS [PATIENT_MIDDLE_NAME]
		,[CRS].[PATIENT].[OEFOIF_IND] AS [PATIENT_OEFOIF_IND]
		,[CRS].[PATIENT].[PATIENT_ID] AS [PATIENT_PATIENT_ID]
		,[CRS].[PATIENT].[PATIENTSID] AS [PATIENT_PATIENTSID]
		,[CRS].[PATIENT].[PERFERRED_ADDRESS_TYPE] AS [PATIENT_PERFERRED_ADDRESS_TYPE]
		,[CRS].[PATIENT].[UPDATED] AS [PATIENT_UPDATED]
		,[CRS].[PATIENT].[UPDATEDBY] AS [PATIENT_UPDATEDBY]
		,[CRS].[PATIENT].[PatientICN] AS [PATIENT_PatientICN]

		,[CRS].[SPATIENT].[AddressChangeInstitutionIEN] AS [SPATIENT_AddressChangeInstitutionIEN]
		,[CRS].[SPATIENT].[AddressChangeInstitutionSID] AS [SPATIENT_AddressChangeInstitutionSID]
		,[CRS].[SPATIENT].[AddressChangeStaffIEN] AS [SPATIENT_AddressChangeStaffIEN]
		,[CRS].[SPATIENT].[AddressChangeStaffSID] AS [SPATIENT_AddressChangeStaffSID]
		,[CRS].[SPATIENT].[Age] AS [SPATIENT_Age]
		,[CRS].[SPATIENT].[BadAddressIndicator] AS [SPATIENT_BadAddressIndicator]
		,[CRS].[SPATIENT].[CDDeterminingInstitutionIEN] AS [SPATIENT_CDDeterminingInstitutionIEN]
		,[CRS].[SPATIENT].[City] AS [SPATIENT_City]
		,[CRS].[SPATIENT].[CombatFromVistaDate] AS [SPATIENT_CombatFromVistaDate]
		,[CRS].[SPATIENT].[CombatToVistaDate] AS [SPATIENT_CombatToVistaDate]
		,[CRS].[SPATIENT].[ConfidentialAddressActiveFlag] AS [SPATIENT_ConfidentialAddressActiveFlag]
		,[CRS].[SPATIENT].[Country] AS [SPATIENT_Country]
		,[CRS].[SPATIENT].[CountryIEN] AS [SPATIENT_CountryIEN]
		,[CRS].[SPATIENT].[CountrySID] AS [SPATIENT_CountrySID]
		,[CRS].[SPATIENT].[County] AS [SPATIENT_County]
		,[CRS].[SPATIENT].[Created] AS [SPATIENT_Created]
		,[CRS].[SPATIENT].[CreatedBy] AS [SPATIENT_CreatedBy]
		,[CRS].[SPATIENT].[CurrentMeansTestStatusIEN] AS [SPATIENT_CurrentMeansTestStatusIEN]
		,[CRS].[SPATIENT].[DateOfBirth] AS [SPATIENT_DateOfBirth]
		,[CRS].[SPATIENT].[DateOfBirthText] AS [SPATIENT_DateOfBirthText]
		,[CRS].[SPATIENT].[DateOfDeath] AS [SPATIENT_DateOfDeath]
		,[CRS].[SPATIENT].[DateOfDeathText] AS [SPATIENT_DateOfDeathText]
		,[CRS].[SPATIENT].[Deceased] AS [SPATIENT_Deceased]
		,[CRS].[SPATIENT].[DEFAULT_RECORD] AS [SPATIENT_DEFAULT_RECORD]
		,[CRS].[SPATIENT].[Eligibility] AS [SPATIENT_Eligibility]
		,[CRS].[SPATIENT].[EligibilityIEN] AS [SPATIENT_EligibilityIEN]
		,[CRS].[SPATIENT].[EligibilitySID] AS [SPATIENT_EligibilitySID]
		,[CRS].[SPATIENT].[EligibilityStatus] AS [SPATIENT_EligibilityStatus]
		,[CRS].[SPATIENT].[EligibilityVACode] AS [SPATIENT_EligibilityVACode]
		,[CRS].[SPATIENT].[EligibilityVerificationSource] AS [SPATIENT_EligibilityVerificationSource]
		,[CRS].[SPATIENT].[EmailAddress] AS [SPATIENT_EmailAddress]
		,[CRS].[SPATIENT].[EnteredIntoFileDate] AS [SPATIENT_EnteredIntoFileDate]
		,[CRS].[SPATIENT].[EnteredIntoFileDateTransformSID] AS [SPATIENT_EnteredIntoFileDateTransformSID]
		,[CRS].[SPATIENT].[EnteredIntoFileVistaErrorDate] AS [SPATIENT_EnteredIntoFileVistaErrorDate]
		,[CRS].[SPATIENT].[ETLBatchID] AS [SPATIENT_ETLBatchID]
		,[CRS].[SPATIENT].[ExcludeFromFacilityDirectoryFlag] AS [SPATIENT_ExcludeFromFacilityDirectoryFlag]
		,[CRS].[SPATIENT].[Gender] AS [SPATIENT_Gender]
		,[CRS].[SPATIENT].[GISAddressType] AS [SPATIENT_GISAddressType]
		,[CRS].[SPATIENT].[GISAddressUpdatedDate] AS [SPATIENT_GISAddressUpdatedDate]
		,[CRS].[SPATIENT].[GISCongressDistrict] AS [SPATIENT_GISCongressDistrict]
		,[CRS].[SPATIENT].[GISFIPSCode] AS [SPATIENT_GISFIPSCode]
		,[CRS].[SPATIENT].[GISLocatorName] AS [SPATIENT_GISLocatorName]
		,[CRS].[SPATIENT].[GISMarket] AS [SPATIENT_GISMarket]
		,[CRS].[SPATIENT].[GISMatchedAddress] AS [SPATIENT_GISMatchedAddress]
		,[CRS].[SPATIENT].[GISMatchMethodCode] AS [SPATIENT_GISMatchMethodCode]
		,[CRS].[SPATIENT].[GISMatchScore] AS [SPATIENT_GISMatchScore]
		,[CRS].[SPATIENT].[GISMatchStatusCode] AS [SPATIENT_GISMatchStatusCode]
		,[CRS].[SPATIENT].[GISPatientAddressLatitude] AS [SPATIENT_GISPatientAddressLatitude]
		,[CRS].[SPATIENT].[GISPatientAddressLongitude] AS [SPATIENT_GISPatientAddressLongitude]
		,[CRS].[SPATIENT].[GISSector] AS [SPATIENT_GISSector]
		,[CRS].[SPATIENT].[GISStreetSide] AS [SPATIENT_GISStreetSide]
		,[CRS].[SPATIENT].[GISSubmarket] AS [SPATIENT_GISSubmarket]
		,[CRS].[SPATIENT].[GISURH] AS [SPATIENT_GISURH]
		,[CRS].[SPATIENT].[InsuranceCoverageFlag] AS [SPATIENT_InsuranceCoverageFlag]
		,[CRS].[SPATIENT].[LastServiceEntryDate] AS [SPATIENT_LastServiceEntryDate]
		,[CRS].[SPATIENT].[LastServiceEntryDateTransformSID] AS [SPATIENT_LastServiceEntryDateTransformSID]
		,[CRS].[SPATIENT].[LastServiceEntryVistaErrorDate] AS [SPATIENT_LastServiceEntryVistaErrorDate]
		,[CRS].[SPATIENT].[LastServiceSeparationDate] AS [SPATIENT_LastServiceSeparationDate]
		,[CRS].[SPATIENT].[LastServiceSeparationDateTransformSID] AS [SPATIENT_LastServiceSeparationDateTransformSID]
		,[CRS].[SPATIENT].[LastServiceSeparationVistaErrorDate] AS [SPATIENT_LastServiceSeparationVistaErrorDate]
		,[CRS].[SPATIENT].[MaritalStatus] AS [SPATIENT_MaritalStatus]
		,[CRS].[SPATIENT].[MaritalStatusIEN] AS [SPATIENT_MaritalStatusIEN]
		,[CRS].[SPATIENT].[MaritalStatusSID] AS [SPATIENT_MaritalStatusSID]
		,[CRS].[SPATIENT].[MedicaidNumber] AS [SPATIENT_MedicaidNumber]
		,[CRS].[SPATIENT].[MothersMaidenName] AS [SPATIENT_MothersMaidenName]
		,[CRS].[SPATIENT].[OEF_OIF_IND] AS [SPATIENT_OEF_OIF_IND]
		,[CRS].[SPATIENT].[OpCode] AS [SPATIENT_OpCode]
		,[CRS].[SPATIENT].[Patient_ID] AS [SPATIENT_Patient_ID]
		,[CRS].[SPATIENT].[PatientFirstName] AS [SPATIENT_PatientFirstName]
		,[CRS].[SPATIENT].[PatientICN] AS [SPATIENT_PatientICN]
		,[CRS].[SPATIENT].[PatientICNChecksum] AS [SPATIENT_PatientICNChecksum]
		,[CRS].[SPATIENT].[PatientIEN] AS [SPATIENT_PatientIEN]
		,[CRS].[SPATIENT].[PatientLastName] AS [SPATIENT_PatientLastName]
		,[CRS].[SPATIENT].[PatientName] AS [SPATIENT_PatientName]
		,[CRS].[SPATIENT].[PatientSID] AS [SPATIENT_PatientSID]
		,[CRS].[SPATIENT].[PatientSSN] AS [SPATIENT_PatientSSN]
		,[CRS].[SPATIENT].[PercentServiceConnect] AS [SPATIENT_PercentServiceConnect]
		,[CRS].[SPATIENT].[PeriodOfService] AS [SPATIENT_PeriodOfService]
		,[CRS].[SPATIENT].[PeriodOfServiceIEN] AS [SPATIENT_PeriodOfServiceIEN]
		,[CRS].[SPATIENT].[PeriodOfServiceSID] AS [SPATIENT_PeriodOfServiceSID]
		,[CRS].[SPATIENT].[PhoneCellular] AS [SPATIENT_PhoneCellular]
		,[CRS].[SPATIENT].[PhoneResidence] AS [SPATIENT_PhoneResidence]
		,[CRS].[SPATIENT].[PhoneWork] AS [SPATIENT_PhoneWork]
		,[CRS].[SPATIENT].[PK_ID] AS [SPATIENT_PK_ID]
		,ISNULL([CRS].[SPATIENT].[PostalCode],[CRS].[SPATIENT].[Zip]) AS [SPATIENT_PostalCode]
		,[CRS].[SPATIENT].[POWLocationIEN] AS [SPATIENT_POWLocationIEN]
		,[CRS].[SPATIENT].[PreferredInstitutionIEN] AS [SPATIENT_PreferredInstitutionIEN]
		,[CRS].[SPATIENT].[Province] AS [SPATIENT_Province]
		,[CRS].[SPATIENT].[PseudoSSNFlag] AS [SPATIENT_PseudoSSNFlag]
		,[CRS].[SPATIENT].[PurpleHeartInstitutionIEN] AS [SPATIENT_PurpleHeartInstitutionIEN]
		,[CRS].[SPATIENT].[Race] AS [SPATIENT_Race]
		,[CRS].[SPATIENT].[RaceIEN] AS [SPATIENT_RaceIEN]
		,[CRS].[SPATIENT].[RaceSID] AS [SPATIENT_RaceSID]
		,[CRS].[SPATIENT].[Religion] AS [SPATIENT_Religion]
		,[CRS].[SPATIENT].[ReligionIEN] AS [SPATIENT_ReligionIEN]
		,[CRS].[SPATIENT].[ReligionSID] AS [SPATIENT_ReligionSID]
		,[CRS].[SPATIENT].[RoomBedIEN] AS [SPATIENT_RoomBedIEN]
		,[CRS].[SPATIENT].[ScrSSN] AS [SPATIENT_ScrSSN]
		,[CRS].[SPATIENT].[SensitiveFlag] AS [SPATIENT_SensitiveFlag]
		,[CRS].[SPATIENT].[Sta3n] AS [SPATIENT_Sta3n]
		,[CRS].[SPATIENT].[State] AS [SPATIENT_State]
		,[CRS].[SPATIENT].[StateIEN] AS [SPATIENT_StateIEN]
		,[CRS].[SPATIENT].[StateSID] AS [SPATIENT_StateSID]
		,[CRS].[SPATIENT].[STD_COMBATLOCATION_ID] AS [SPATIENT_STD_COMBATLOCATION_ID]
		,[CRS].[SPATIENT].[STD_ENTHNICITY_ID] AS [SPATIENT_STD_ENTHNICITY_ID]
		,[CRS].[SPATIENT].[STD_GENDER_ID] AS [SPATIENT_STD_GENDER_ID]
		,[CRS].[SPATIENT].[STD_MARITALSTATUS_ID] AS [SPATIENT_STD_MARITALSTATUS_ID]
		,[CRS].[SPATIENT].[STD_RACE_ID] AS [SPATIENT_STD_RACE_ID]
		,[CRS].[SPATIENT].[STD_SERVICEBRANCH_ID] AS [SPATIENT_STD_SERVICEBRANCH_ID]
		,[CRS].[SPATIENT].[StdRegistryId] AS [SPATIENT_StdRegistryId]
		,[CRS].[SPATIENT].[StreetAddress1] AS [SPATIENT_StreetAddress1]
		,[CRS].[SPATIENT].[StreetAddress2] AS [SPATIENT_StreetAddress2]
		,[CRS].[SPATIENT].[StreetAddress3] AS [SPATIENT_StreetAddress3]
		,[CRS].[SPATIENT].[TemporaryAddressChangeInstitutionIEN] AS [SPATIENT_TemporaryAddressChangeInstitutionIEN]
		,[CRS].[SPATIENT].[Updatedate] AS [SPATIENT_Updatedate]
		,[CRS].[SPATIENT].[UpdatedBy] AS [SPATIENT_UpdatedBy]
		,[CRS].[SPATIENT].[VeteranFlag] AS [SPATIENT_VeteranFlag]
		,[CRS].[SPATIENT].[VistaCreateDate] AS [SPATIENT_VistaCreateDate]
		,[CRS].[SPATIENT].[VistaEditDate] AS [SPATIENT_VistaEditDate]
		,ISNULL([CRS].[SPATIENT].[Zip],[CRS].[SPATIENT].[PostalCode]) AS [SPATIENT_Zip]
		,[CRS].[SPATIENT].[Zip4] AS [SPATIENT_Zip4]
		,RIGHT(ISNULL([CRS].[SPATIENT].[PatientSSN], '0000'), 4) AS [SPATIENT_PatientLastFour]
	FROM 
		[CRS].[PATIENT] 
			LEFT OUTER JOIN [CRS].[SPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
	WHERE [CRS].[PATIENT].[PATIENT_ID] = @PATIENT_ID;
END

GO
-- =============================================
-- Author:        
-- Create date:   12/15/2015
-- Description:   Get all records by Name
---               Updated Stored Procedure to Display either Zip or PostalCode from SPATIENT table.
-- =============================================
ALTER PROCEDURE [CRS].[usp_PATIENT_getitemsByName] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @LAST_NAME varchar(50), @FIRST_NAME varchar(50))
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_PATIENT_getitemsByName', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT 
		[CRS].[PATIENT].[BIRTH_DATE] AS [PATIENT_BIRTH_DATE]
		,[CRS].[PATIENT].[CELL_PHONE] AS [PATIENT_CELL_PHONE]
		,[CRS].[PATIENT].[CREATED] AS [PATIENT_CREATED]
		,[CRS].[PATIENT].[CREATEDBY] AS [PATIENT_CREATEDBY]
		,[CRS].[PATIENT].[DEATH_DATE] AS [PATIENT_DEATH_DATE]
		,[CRS].[PATIENT].[EMAIL_ADDRESS] AS [PATIENT_EMAIL_ADDRESS]
		,[CRS].[PATIENT].[FIRST_NAME] AS [PATIENT_FIRST_NAME]
		,[CRS].[PATIENT].[LAST_NAME] AS [PATIENT_LAST_NAME]
		,[CRS].[PATIENT].[MIDDLE_NAME] AS [PATIENT_MIDDLE_NAME]
		,[CRS].[PATIENT].[OEFOIF_IND] AS [PATIENT_OEFOIF_IND]
		,[CRS].[PATIENT].[PATIENT_ID] AS [PATIENT_PATIENT_ID]
		,[CRS].[PATIENT].[PATIENTSID] AS [PATIENT_PATIENTSID]
		,[CRS].[PATIENT].[PERFERRED_ADDRESS_TYPE] AS [PATIENT_PERFERRED_ADDRESS_TYPE]
		,[CRS].[PATIENT].[UPDATED] AS [PATIENT_UPDATED]
		,[CRS].[PATIENT].[UPDATEDBY] AS [PATIENT_UPDATEDBY]
		,[CRS].[PATIENT].[PatientICN] AS [PATIENT_PatientICN]

		,[CRS].[SPATIENT].[AddressChangeInstitutionIEN] AS [SPATIENT_AddressChangeInstitutionIEN]
		,[CRS].[SPATIENT].[AddressChangeInstitutionSID] AS [SPATIENT_AddressChangeInstitutionSID]
		,[CRS].[SPATIENT].[AddressChangeStaffIEN] AS [SPATIENT_AddressChangeStaffIEN]
		,[CRS].[SPATIENT].[AddressChangeStaffSID] AS [SPATIENT_AddressChangeStaffSID]
		,[CRS].[SPATIENT].[Age] AS [SPATIENT_Age]
		,[CRS].[SPATIENT].[BadAddressIndicator] AS [SPATIENT_BadAddressIndicator]
		,[CRS].[SPATIENT].[CDDeterminingInstitutionIEN] AS [SPATIENT_CDDeterminingInstitutionIEN]
		,[CRS].[SPATIENT].[City] AS [SPATIENT_City]
		,[CRS].[SPATIENT].[CombatFromVistaDate] AS [SPATIENT_CombatFromVistaDate]
		,[CRS].[SPATIENT].[CombatToVistaDate] AS [SPATIENT_CombatToVistaDate]
		,[CRS].[SPATIENT].[ConfidentialAddressActiveFlag] AS [SPATIENT_ConfidentialAddressActiveFlag]
		,[CRS].[SPATIENT].[Country] AS [SPATIENT_Country]
		,[CRS].[SPATIENT].[CountryIEN] AS [SPATIENT_CountryIEN]
		,[CRS].[SPATIENT].[CountrySID] AS [SPATIENT_CountrySID]
		,[CRS].[SPATIENT].[County] AS [SPATIENT_County]
		,[CRS].[SPATIENT].[Created] AS [SPATIENT_Created]
		,[CRS].[SPATIENT].[CreatedBy] AS [SPATIENT_CreatedBy]
		,[CRS].[SPATIENT].[CurrentMeansTestStatusIEN] AS [SPATIENT_CurrentMeansTestStatusIEN]
		,[CRS].[SPATIENT].[DateOfBirth] AS [SPATIENT_DateOfBirth]
		,[CRS].[SPATIENT].[DateOfBirthText] AS [SPATIENT_DateOfBirthText]
		,[CRS].[SPATIENT].[DateOfDeath] AS [SPATIENT_DateOfDeath]
		,[CRS].[SPATIENT].[DateOfDeathText] AS [SPATIENT_DateOfDeathText]
		,[CRS].[SPATIENT].[Deceased] AS [SPATIENT_Deceased]
		,[CRS].[SPATIENT].[DEFAULT_RECORD] AS [SPATIENT_DEFAULT_RECORD]
		,[CRS].[SPATIENT].[Eligibility] AS [SPATIENT_Eligibility]
		,[CRS].[SPATIENT].[EligibilityIEN] AS [SPATIENT_EligibilityIEN]
		,[CRS].[SPATIENT].[EligibilitySID] AS [SPATIENT_EligibilitySID]
		,[CRS].[SPATIENT].[EligibilityStatus] AS [SPATIENT_EligibilityStatus]
		,[CRS].[SPATIENT].[EligibilityVACode] AS [SPATIENT_EligibilityVACode]
		,[CRS].[SPATIENT].[EligibilityVerificationSource] AS [SPATIENT_EligibilityVerificationSource]
		,[CRS].[SPATIENT].[EmailAddress] AS [SPATIENT_EmailAddress]
		,[CRS].[SPATIENT].[EnteredIntoFileDate] AS [SPATIENT_EnteredIntoFileDate]
		,[CRS].[SPATIENT].[EnteredIntoFileDateTransformSID] AS [SPATIENT_EnteredIntoFileDateTransformSID]
		,[CRS].[SPATIENT].[EnteredIntoFileVistaErrorDate] AS [SPATIENT_EnteredIntoFileVistaErrorDate]
		,[CRS].[SPATIENT].[ETLBatchID] AS [SPATIENT_ETLBatchID]
		,[CRS].[SPATIENT].[ExcludeFromFacilityDirectoryFlag] AS [SPATIENT_ExcludeFromFacilityDirectoryFlag]
		,[CRS].[SPATIENT].[Gender] AS [SPATIENT_Gender]
		,[CRS].[SPATIENT].[GISAddressType] AS [SPATIENT_GISAddressType]
		,[CRS].[SPATIENT].[GISAddressUpdatedDate] AS [SPATIENT_GISAddressUpdatedDate]
		,[CRS].[SPATIENT].[GISCongressDistrict] AS [SPATIENT_GISCongressDistrict]
		,[CRS].[SPATIENT].[GISFIPSCode] AS [SPATIENT_GISFIPSCode]
		,[CRS].[SPATIENT].[GISLocatorName] AS [SPATIENT_GISLocatorName]
		,[CRS].[SPATIENT].[GISMarket] AS [SPATIENT_GISMarket]
		,[CRS].[SPATIENT].[GISMatchedAddress] AS [SPATIENT_GISMatchedAddress]
		,[CRS].[SPATIENT].[GISMatchMethodCode] AS [SPATIENT_GISMatchMethodCode]
		,[CRS].[SPATIENT].[GISMatchScore] AS [SPATIENT_GISMatchScore]
		,[CRS].[SPATIENT].[GISMatchStatusCode] AS [SPATIENT_GISMatchStatusCode]
		,[CRS].[SPATIENT].[GISPatientAddressLatitude] AS [SPATIENT_GISPatientAddressLatitude]
		,[CRS].[SPATIENT].[GISPatientAddressLongitude] AS [SPATIENT_GISPatientAddressLongitude]
		,[CRS].[SPATIENT].[GISSector] AS [SPATIENT_GISSector]
		,[CRS].[SPATIENT].[GISStreetSide] AS [SPATIENT_GISStreetSide]
		,[CRS].[SPATIENT].[GISSubmarket] AS [SPATIENT_GISSubmarket]
		,[CRS].[SPATIENT].[GISURH] AS [SPATIENT_GISURH]
		,[CRS].[SPATIENT].[InsuranceCoverageFlag] AS [SPATIENT_InsuranceCoverageFlag]
		,[CRS].[SPATIENT].[LastServiceEntryDate] AS [SPATIENT_LastServiceEntryDate]
		,[CRS].[SPATIENT].[LastServiceEntryDateTransformSID] AS [SPATIENT_LastServiceEntryDateTransformSID]
		,[CRS].[SPATIENT].[LastServiceEntryVistaErrorDate] AS [SPATIENT_LastServiceEntryVistaErrorDate]
		,[CRS].[SPATIENT].[LastServiceSeparationDate] AS [SPATIENT_LastServiceSeparationDate]
		,[CRS].[SPATIENT].[LastServiceSeparationDateTransformSID] AS [SPATIENT_LastServiceSeparationDateTransformSID]
		,[CRS].[SPATIENT].[LastServiceSeparationVistaErrorDate] AS [SPATIENT_LastServiceSeparationVistaErrorDate]
		,[CRS].[SPATIENT].[MaritalStatus] AS [SPATIENT_MaritalStatus]
		,[CRS].[SPATIENT].[MaritalStatusIEN] AS [SPATIENT_MaritalStatusIEN]
		,[CRS].[SPATIENT].[MaritalStatusSID] AS [SPATIENT_MaritalStatusSID]
		,[CRS].[SPATIENT].[MedicaidNumber] AS [SPATIENT_MedicaidNumber]
		,[CRS].[SPATIENT].[MothersMaidenName] AS [SPATIENT_MothersMaidenName]
		,[CRS].[SPATIENT].[OEF_OIF_IND] AS [SPATIENT_OEF_OIF_IND]
		,[CRS].[SPATIENT].[OpCode] AS [SPATIENT_OpCode]
		,[CRS].[SPATIENT].[Patient_ID] AS [SPATIENT_Patient_ID]
		,[CRS].[SPATIENT].[PatientFirstName] AS [SPATIENT_PatientFirstName]
		,[CRS].[SPATIENT].[PatientICN] AS [SPATIENT_PatientICN]
		,[CRS].[SPATIENT].[PatientICNChecksum] AS [SPATIENT_PatientICNChecksum]
		,[CRS].[SPATIENT].[PatientIEN] AS [SPATIENT_PatientIEN]
		,[CRS].[SPATIENT].[PatientLastName] AS [SPATIENT_PatientLastName]
		,[CRS].[SPATIENT].[PatientName] AS [SPATIENT_PatientName]
		,[CRS].[SPATIENT].[PatientSID] AS [SPATIENT_PatientSID]
		,[CRS].[SPATIENT].[PatientSSN] AS [SPATIENT_PatientSSN]
		,[CRS].[SPATIENT].[PercentServiceConnect] AS [SPATIENT_PercentServiceConnect]
		,[CRS].[SPATIENT].[PeriodOfService] AS [SPATIENT_PeriodOfService]
		,[CRS].[SPATIENT].[PeriodOfServiceIEN] AS [SPATIENT_PeriodOfServiceIEN]
		,[CRS].[SPATIENT].[PeriodOfServiceSID] AS [SPATIENT_PeriodOfServiceSID]
		,[CRS].[SPATIENT].[PhoneCellular] AS [SPATIENT_PhoneCellular]
		,[CRS].[SPATIENT].[PhoneResidence] AS [SPATIENT_PhoneResidence]
		,[CRS].[SPATIENT].[PhoneWork] AS [SPATIENT_PhoneWork]
		,[CRS].[SPATIENT].[PK_ID] AS [SPATIENT_PK_ID]
		,ISNULL([CRS].[SPATIENT].[PostalCode],[CRS].[SPATIENT].[Zip]) AS [SPATIENT_PostalCode]
		,[CRS].[SPATIENT].[POWLocationIEN] AS [SPATIENT_POWLocationIEN]
		,[CRS].[SPATIENT].[PreferredInstitutionIEN] AS [SPATIENT_PreferredInstitutionIEN]
		,[CRS].[SPATIENT].[Province] AS [SPATIENT_Province]
		,[CRS].[SPATIENT].[PseudoSSNFlag] AS [SPATIENT_PseudoSSNFlag]
		,[CRS].[SPATIENT].[PurpleHeartInstitutionIEN] AS [SPATIENT_PurpleHeartInstitutionIEN]
		,[CRS].[SPATIENT].[Race] AS [SPATIENT_Race]
		,[CRS].[SPATIENT].[RaceIEN] AS [SPATIENT_RaceIEN]
		,[CRS].[SPATIENT].[RaceSID] AS [SPATIENT_RaceSID]
		,[CRS].[SPATIENT].[Religion] AS [SPATIENT_Religion]
		,[CRS].[SPATIENT].[ReligionIEN] AS [SPATIENT_ReligionIEN]
		,[CRS].[SPATIENT].[ReligionSID] AS [SPATIENT_ReligionSID]
		,[CRS].[SPATIENT].[RoomBedIEN] AS [SPATIENT_RoomBedIEN]
		,[CRS].[SPATIENT].[ScrSSN] AS [SPATIENT_ScrSSN]
		,[CRS].[SPATIENT].[SensitiveFlag] AS [SPATIENT_SensitiveFlag]
		,[CRS].[SPATIENT].[Sta3n] AS [SPATIENT_Sta3n]
		,[CRS].[SPATIENT].[State] AS [SPATIENT_State]
		,[CRS].[SPATIENT].[StateIEN] AS [SPATIENT_StateIEN]
		,[CRS].[SPATIENT].[StateSID] AS [SPATIENT_StateSID]
		,[CRS].[SPATIENT].[STD_COMBATLOCATION_ID] AS [SPATIENT_STD_COMBATLOCATION_ID]
		,[CRS].[SPATIENT].[STD_ENTHNICITY_ID] AS [SPATIENT_STD_ENTHNICITY_ID]
		,[CRS].[SPATIENT].[STD_GENDER_ID] AS [SPATIENT_STD_GENDER_ID]
		,[CRS].[SPATIENT].[STD_MARITALSTATUS_ID] AS [SPATIENT_STD_MARITALSTATUS_ID]
		,[CRS].[SPATIENT].[STD_RACE_ID] AS [SPATIENT_STD_RACE_ID]
		,[CRS].[SPATIENT].[STD_SERVICEBRANCH_ID] AS [SPATIENT_STD_SERVICEBRANCH_ID]
		,[CRS].[SPATIENT].[StdRegistryId] AS [SPATIENT_StdRegistryId]
		,[CRS].[SPATIENT].[StreetAddress1] AS [SPATIENT_StreetAddress1]
		,[CRS].[SPATIENT].[StreetAddress2] AS [SPATIENT_StreetAddress2]
		,[CRS].[SPATIENT].[StreetAddress3] AS [SPATIENT_StreetAddress3]
		,[CRS].[SPATIENT].[TemporaryAddressChangeInstitutionIEN] AS [SPATIENT_TemporaryAddressChangeInstitutionIEN]
		,[CRS].[SPATIENT].[Updatedate] AS [SPATIENT_Updatedate]
		,[CRS].[SPATIENT].[UpdatedBy] AS [SPATIENT_UpdatedBy]
		,[CRS].[SPATIENT].[VeteranFlag] AS [SPATIENT_VeteranFlag]
		,[CRS].[SPATIENT].[VistaCreateDate] AS [SPATIENT_VistaCreateDate]
		,[CRS].[SPATIENT].[VistaEditDate] AS [SPATIENT_VistaEditDate]
		,ISNULL([CRS].[SPATIENT].[Zip],[CRS].[SPATIENT].[PostalCode]) AS [SPATIENT_Zip]
		,[CRS].[SPATIENT].[Zip4] AS [SPATIENT_Zip4]
		,RIGHT(ISNULL([CRS].[SPATIENT].[PatientSSN], '0000'), 4) AS [SPATIENT_PatientLastFour]
	FROM 
		[CRS].[PATIENT]
			INNER JOIN [CRS].[SPATIENT] ON [CRS].[SPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
	WHERE
		(ISNULL(@LAST_NAME, '') <> '' AND [CRS].[PATIENT].[LAST_NAME] LIKE ('%' + @LAST_NAME + '%') AND ISNULL(@FIRST_NAME, '') <> '' AND [CRS].[PATIENT].[FIRST_NAME] LIKE ('%' + @FIRST_NAME + '%'))
		OR (ISNULL(@LAST_NAME, '') <> '' AND [CRS].[PATIENT].[LAST_NAME] LIKE ('%' + @LAST_NAME + '%') AND ISNULL(@FIRST_NAME, '') = '')
		OR (ISNULL(@FIRST_NAME, '') <> '' AND [CRS].[PATIENT].[FIRST_NAME] LIKE ('%' + @FIRST_NAME + '%') AND ISNULL(@LAST_NAME, '') = '');
END


GO
-- =============================================
-- Author:        
-- Create date:   12/28/2015
-- Description:   Get record by ID
---               Updated Stored Procedure to Display either Zip or PostalCode from SPATIENT table.
-- =============================================
ALTER PROCEDURE [CRS].[usp_REFERRAL_getitemComplete] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_REFERRAL_getitemComplete', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

		SELECT 
		[CRS].[REFERRAL].[COMMENT_TEXT] AS [REFERRAL_COMMENT_TEXT]
		,[CRS].[REFERRAL].[CREATED] AS [REFERRAL_CREATED]
		,[CRS].[REFERRAL].[CREATEDBY] AS [REFERRAL_CREATEDBY]
		,[CRS].[REFERRAL].[CREATEDSOURCE] AS [REFERRAL_CREATEDSOURCE]
		,[CRS].[REFERRAL].[DUPLICATE_FLAG] AS [REFERRAL_DUPLICATE_FLAG]
		,[CRS].[REFERRAL].[PATIENT_ID] AS [REFERRAL_PATIENT_ID]
		,[CRS].[REFERRAL].[PROVIDER_ID] AS [REFERRAL_PROVIDER_ID]
		,[CRS].[REFERRAL].[REFERRAL_CLASS_TEXT] AS [REFERRAL_REFERRAL_CLASS_TEXT]
		,[CRS].[REFERRAL].[REFERRAL_DATE] AS [REFERRAL_REFERRAL_DATE]
		,[CRS].[REFERRAL].[REFERRAL_ID] AS [REFERRAL_REFERRAL_ID]
		,[CRS].[REFERRAL].[REVIEW_BY] AS [REFERRAL_REVIEW_BY]
		,[CRS].[REFERRAL].[REVIEW_DATE] AS [REFERRAL_REVIEW_DATE]
		,[CRS].[REFERRAL].[STD_REFERRALSTS_ID] AS [REFERRAL_STD_REFERRALSTS_ID]
		,[CRS].[REFERRAL].[STD_REGISTRY_ID] AS [REFERRAL_STD_REGISTRY_ID]
		,[CRS].[REFERRAL].[STD_REMINDERCLASS_ID] AS [REFERRAL_STD_REMINDERCLASS_ID]
		,[CRS].[REFERRAL].[UPDATED] AS [REFERRAL_UPDATED]
		,[CRS].[REFERRAL].[UPDATEDBY] AS [REFERRAL_UPDATEDBY]
		,[CRS].[REFERRAL].[UPDATEDSOURCE] AS [REFERRAL_UPDATEDSOURCE]

		,[CRS].[STD_REGISTRY].[CODE] AS [STD_REGISTRY_CODE]
		,[CRS].[STD_REGISTRY].[COMMENTS] AS [STD_REGISTRY_COMMENTS]
		,[CRS].[STD_REGISTRY].[CREATED] AS [STD_REGISTRY_CREATED]
		,[CRS].[STD_REGISTRY].[CREATEDBY] AS [STD_REGISTRY_CREATEDBY]
		,[CRS].[STD_REGISTRY].[DESCRIPTION_TEXT] AS [STD_REGISTRY_DESCRIPTION_TEXT]
		,[CRS].[STD_REGISTRY].[ID] AS [STD_REGISTRY_ID]
		,[CRS].[STD_REGISTRY].[INACTIVE_DATE] AS [STD_REGISTRY_INACTIVE_DATE]
		,[CRS].[STD_REGISTRY].[INACTIVE_FLAG] AS [STD_REGISTRY_INACTIVE_FLAG]
		,[CRS].[STD_REGISTRY].[NAME] AS [STD_REGISTRY_NAME]
		,[CRS].[STD_REGISTRY].[REGISTRY_ADMINISTRATOR] AS [STD_REGISTRY_REGISTRY_ADMINISTRATOR]
		,[CRS].[STD_REGISTRY].[REGISTRY_OWNER] AS [STD_REGISTRY_REGISTRY_OWNER]
		,[CRS].[STD_REGISTRY].[REGISTRY_SUPPORT_CONTACT] AS [STD_REGISTRY_REGISTRY_SUPPORT_CONTACT]
		,[CRS].[STD_REGISTRY].[SORT_ORDER] AS [STD_REGISTRY_SORT_ORDER]
		,[CRS].[STD_REGISTRY].[UPDATED] AS [STD_REGISTRY_UPDATED]
		,[CRS].[STD_REGISTRY].[UPDATEDBY] AS [STD_REGISTRY_UPDATEDBY]

		,[CRS].[PATIENT].[BIRTH_DATE] AS [PATIENT_BIRTH_DATE]
		,[CRS].[PATIENT].[CELL_PHONE] AS [PATIENT_CELL_PHONE]
		,[CRS].[PATIENT].[CREATED] AS [PATIENT_CREATED]
		,[CRS].[PATIENT].[CREATEDBY] AS [PATIENT_CREATEDBY]
		,[CRS].[PATIENT].[DEATH_DATE] AS [PATIENT_DEATH_DATE]
		,[CRS].[PATIENT].[EMAIL_ADDRESS] AS [PATIENT_EMAIL_ADDRESS]
		,[CRS].[PATIENT].[FIRST_NAME] AS [PATIENT_FIRST_NAME]
		,[CRS].[PATIENT].[LAST_NAME] AS [PATIENT_LAST_NAME]
		,[CRS].[PATIENT].[MIDDLE_NAME] AS [PATIENT_MIDDLE_NAME]
		,[CRS].[PATIENT].[OEFOIF_IND] AS [PATIENT_OEFOIF_IND]
		,[CRS].[PATIENT].[PATIENT_ID] AS [PATIENT_PATIENT_ID]
		,[CRS].[PATIENT].[PATIENTSID] AS [PATIENT_PATIENTSID]
		,[CRS].[PATIENT].[PERFERRED_ADDRESS_TYPE] AS [PATIENT_PERFERRED_ADDRESS_TYPE]
		,[CRS].[PATIENT].[UPDATED] AS [PATIENT_UPDATED]
		,[CRS].[PATIENT].[UPDATEDBY] AS [PATIENT_UPDATEDBY]
		,[CRS].[PATIENT].[PatientICN] AS [PATIENT_PatientICN]

		,[CRS].[STD_REFERRALSTS].[CODE] AS [STD_REFERRALSTS_CODE]
		,[CRS].[STD_REFERRALSTS].[CREATED] AS [STD_REFERRALSTS_CREATED]
		,[CRS].[STD_REFERRALSTS].[CREATEDBY] AS [STD_REFERRALSTS_CREATEDBY]
		,[CRS].[STD_REFERRALSTS].[DESCRIPTION_TEXT] AS [STD_REFERRALSTS_DESCRIPTION_TEXT]
		,[CRS].[STD_REFERRALSTS].[ID] AS [STD_REFERRALSTS_ID]
		,[CRS].[STD_REFERRALSTS].[INACTIVE_DATE] AS [STD_REFERRALSTS_INACTIVE_DATE]
		,[CRS].[STD_REFERRALSTS].[INACTIVE_FLAG] AS [STD_REFERRALSTS_INACTIVE_FLAG]
		,[CRS].[STD_REFERRALSTS].[NAME] AS [STD_REFERRALSTS_NAME]
		,[CRS].[STD_REFERRALSTS].[SORT_ORDER] AS [STD_REFERRALSTS_SORT_ORDER]
		,[CRS].[STD_REFERRALSTS].[STD_REGISTRY_ID] AS [STD_REFERRALSTS_STD_REGISTRY_ID]
		,[CRS].[STD_REFERRALSTS].[UPDATED] AS [STD_REFERRALSTS_UPDATED]
		,[CRS].[STD_REFERRALSTS].[UPDATEDBY] AS [STD_REFERRALSTS_UPDATEDBY]

		,[CRS].[SPATIENT].[AddressChangeInstitutionIEN] AS [SPATIENT_AddressChangeInstitutionIEN]
		,[CRS].[SPATIENT].[AddressChangeInstitutionSID] AS [SPATIENT_AddressChangeInstitutionSID]
		,[CRS].[SPATIENT].[AddressChangeStaffIEN] AS [SPATIENT_AddressChangeStaffIEN]
		,[CRS].[SPATIENT].[AddressChangeStaffSID] AS [SPATIENT_AddressChangeStaffSID]
		,[CRS].[SPATIENT].[Age] AS [SPATIENT_Age]
		,[CRS].[SPATIENT].[BadAddressIndicator] AS [SPATIENT_BadAddressIndicator]
		,[CRS].[SPATIENT].[CDDeterminingInstitutionIEN] AS [SPATIENT_CDDeterminingInstitutionIEN]
		,[CRS].[SPATIENT].[City] AS [SPATIENT_City]
		,[CRS].[SPATIENT].[CombatFromVistaDate] AS [SPATIENT_CombatFromVistaDate]
		,[CRS].[SPATIENT].[CombatToVistaDate] AS [SPATIENT_CombatToVistaDate]
		,[CRS].[SPATIENT].[ConfidentialAddressActiveFlag] AS [SPATIENT_ConfidentialAddressActiveFlag]
		,[CRS].[SPATIENT].[Country] AS [SPATIENT_Country]
		,[CRS].[SPATIENT].[CountryIEN] AS [SPATIENT_CountryIEN]
		,[CRS].[SPATIENT].[CountrySID] AS [SPATIENT_CountrySID]
		,[CRS].[SPATIENT].[County] AS [SPATIENT_County]
		,[CRS].[SPATIENT].[Created] AS [SPATIENT_Created]
		,[CRS].[SPATIENT].[CreatedBy] AS [SPATIENT_CreatedBy]
		,[CRS].[SPATIENT].[CurrentMeansTestStatusIEN] AS [SPATIENT_CurrentMeansTestStatusIEN]
		,[CRS].[SPATIENT].[DateOfBirth] AS [SPATIENT_DateOfBirth]
		,[CRS].[SPATIENT].[DateOfBirthText] AS [SPATIENT_DateOfBirthText]
		,[CRS].[SPATIENT].[DateOfDeath] AS [SPATIENT_DateOfDeath]
		,[CRS].[SPATIENT].[DateOfDeathText] AS [SPATIENT_DateOfDeathText]
		,[CRS].[SPATIENT].[Deceased] AS [SPATIENT_Deceased]
		,[CRS].[SPATIENT].[DEFAULT_RECORD] AS [SPATIENT_DEFAULT_RECORD]
		,[CRS].[SPATIENT].[Eligibility] AS [SPATIENT_Eligibility]
		,[CRS].[SPATIENT].[EligibilityIEN] AS [SPATIENT_EligibilityIEN]
		,[CRS].[SPATIENT].[EligibilitySID] AS [SPATIENT_EligibilitySID]
		,[CRS].[SPATIENT].[EligibilityStatus] AS [SPATIENT_EligibilityStatus]
		,[CRS].[SPATIENT].[EligibilityVACode] AS [SPATIENT_EligibilityVACode]
		,[CRS].[SPATIENT].[EligibilityVerificationSource] AS [SPATIENT_EligibilityVerificationSource]
		,[CRS].[SPATIENT].[EmailAddress] AS [SPATIENT_EmailAddress]
		,[CRS].[SPATIENT].[EnteredIntoFileDate] AS [SPATIENT_EnteredIntoFileDate]
		,[CRS].[SPATIENT].[EnteredIntoFileDateTransformSID] AS [SPATIENT_EnteredIntoFileDateTransformSID]
		,[CRS].[SPATIENT].[EnteredIntoFileVistaErrorDate] AS [SPATIENT_EnteredIntoFileVistaErrorDate]
		,[CRS].[SPATIENT].[ETLBatchID] AS [SPATIENT_ETLBatchID]
		,[CRS].[SPATIENT].[ExcludeFromFacilityDirectoryFlag] AS [SPATIENT_ExcludeFromFacilityDirectoryFlag]
		,[CRS].[SPATIENT].[Gender] AS [SPATIENT_Gender]
		,[CRS].[SPATIENT].[GISAddressType] AS [SPATIENT_GISAddressType]
		,[CRS].[SPATIENT].[GISAddressUpdatedDate] AS [SPATIENT_GISAddressUpdatedDate]
		,[CRS].[SPATIENT].[GISCongressDistrict] AS [SPATIENT_GISCongressDistrict]
		,[CRS].[SPATIENT].[GISFIPSCode] AS [SPATIENT_GISFIPSCode]
		,[CRS].[SPATIENT].[GISLocatorName] AS [SPATIENT_GISLocatorName]
		,[CRS].[SPATIENT].[GISMarket] AS [SPATIENT_GISMarket]
		,[CRS].[SPATIENT].[GISMatchedAddress] AS [SPATIENT_GISMatchedAddress]
		,[CRS].[SPATIENT].[GISMatchMethodCode] AS [SPATIENT_GISMatchMethodCode]
		,[CRS].[SPATIENT].[GISMatchScore] AS [SPATIENT_GISMatchScore]
		,[CRS].[SPATIENT].[GISMatchStatusCode] AS [SPATIENT_GISMatchStatusCode]
		,[CRS].[SPATIENT].[GISPatientAddressLatitude] AS [SPATIENT_GISPatientAddressLatitude]
		,[CRS].[SPATIENT].[GISPatientAddressLongitude] AS [SPATIENT_GISPatientAddressLongitude]
		,[CRS].[SPATIENT].[GISSector] AS [SPATIENT_GISSector]
		,[CRS].[SPATIENT].[GISStreetSide] AS [SPATIENT_GISStreetSide]
		,[CRS].[SPATIENT].[GISSubmarket] AS [SPATIENT_GISSubmarket]
		,[CRS].[SPATIENT].[GISURH] AS [SPATIENT_GISURH]
		,[CRS].[SPATIENT].[InsuranceCoverageFlag] AS [SPATIENT_InsuranceCoverageFlag]
		,[CRS].[SPATIENT].[LastServiceEntryDate] AS [SPATIENT_LastServiceEntryDate]
		,[CRS].[SPATIENT].[LastServiceEntryDateTransformSID] AS [SPATIENT_LastServiceEntryDateTransformSID]
		,[CRS].[SPATIENT].[LastServiceEntryVistaErrorDate] AS [SPATIENT_LastServiceEntryVistaErrorDate]
		,[CRS].[SPATIENT].[LastServiceSeparationDate] AS [SPATIENT_LastServiceSeparationDate]
		,[CRS].[SPATIENT].[LastServiceSeparationDateTransformSID] AS [SPATIENT_LastServiceSeparationDateTransformSID]
		,[CRS].[SPATIENT].[LastServiceSeparationVistaErrorDate] AS [SPATIENT_LastServiceSeparationVistaErrorDate]
		,[CRS].[SPATIENT].[MaritalStatus] AS [SPATIENT_MaritalStatus]
		,[CRS].[SPATIENT].[MaritalStatusIEN] AS [SPATIENT_MaritalStatusIEN]
		,[CRS].[SPATIENT].[MaritalStatusSID] AS [SPATIENT_MaritalStatusSID]
		,[CRS].[SPATIENT].[MedicaidNumber] AS [SPATIENT_MedicaidNumber]
		,[CRS].[SPATIENT].[MothersMaidenName] AS [SPATIENT_MothersMaidenName]
		,[CRS].[SPATIENT].[OEF_OIF_IND] AS [SPATIENT_OEF_OIF_IND]
		,[CRS].[SPATIENT].[OpCode] AS [SPATIENT_OpCode]
		,[CRS].[SPATIENT].[Patient_ID] AS [SPATIENT_Patient_ID]
		,[CRS].[SPATIENT].[PatientFirstName] AS [SPATIENT_PatientFirstName]
		,[CRS].[SPATIENT].[PatientICN] AS [SPATIENT_PatientICN]
		,[CRS].[SPATIENT].[PatientICNChecksum] AS [SPATIENT_PatientICNChecksum]
		,[CRS].[SPATIENT].[PatientIEN] AS [SPATIENT_PatientIEN]
		,[CRS].[SPATIENT].[PatientLastName] AS [SPATIENT_PatientLastName]
		,[CRS].[SPATIENT].[PatientName] AS [SPATIENT_PatientName]
		,[CRS].[SPATIENT].[PatientSID] AS [SPATIENT_PatientSID]
		,[CRS].[SPATIENT].[PatientSSN] AS [SPATIENT_PatientSSN]
		,[CRS].[SPATIENT].[PercentServiceConnect] AS [SPATIENT_PercentServiceConnect]
		,[CRS].[SPATIENT].[PeriodOfService] AS [SPATIENT_PeriodOfService]
		,[CRS].[SPATIENT].[PeriodOfServiceIEN] AS [SPATIENT_PeriodOfServiceIEN]
		,[CRS].[SPATIENT].[PeriodOfServiceSID] AS [SPATIENT_PeriodOfServiceSID]
		,[CRS].[SPATIENT].[PhoneCellular] AS [SPATIENT_PhoneCellular]
		,[CRS].[SPATIENT].[PhoneResidence] AS [SPATIENT_PhoneResidence]
		,[CRS].[SPATIENT].[PhoneWork] AS [SPATIENT_PhoneWork]
		,[CRS].[SPATIENT].[PK_ID] AS [SPATIENT_PK_ID]
		,ISNULL([CRS].[SPATIENT].[PostalCode],[CRS].[SPATIENT].[Zip]) AS [SPATIENT_PostalCode]
		,[CRS].[SPATIENT].[POWLocationIEN] AS [SPATIENT_POWLocationIEN]
		,[CRS].[SPATIENT].[PreferredInstitutionIEN] AS [SPATIENT_PreferredInstitutionIEN]
		,[CRS].[SPATIENT].[Province] AS [SPATIENT_Province]
		,[CRS].[SPATIENT].[PseudoSSNFlag] AS [SPATIENT_PseudoSSNFlag]
		,[CRS].[SPATIENT].[PurpleHeartInstitutionIEN] AS [SPATIENT_PurpleHeartInstitutionIEN]
		,[CRS].[SPATIENT].[Race] AS [SPATIENT_Race]
		,[CRS].[SPATIENT].[RaceIEN] AS [SPATIENT_RaceIEN]
		,[CRS].[SPATIENT].[RaceSID] AS [SPATIENT_RaceSID]
		,[CRS].[SPATIENT].[Religion] AS [SPATIENT_Religion]
		,[CRS].[SPATIENT].[ReligionIEN] AS [SPATIENT_ReligionIEN]
		,[CRS].[SPATIENT].[ReligionSID] AS [SPATIENT_ReligionSID]
		,[CRS].[SPATIENT].[RoomBedIEN] AS [SPATIENT_RoomBedIEN]
		,[CRS].[SPATIENT].[ScrSSN] AS [SPATIENT_ScrSSN]
		,[CRS].[SPATIENT].[SensitiveFlag] AS [SPATIENT_SensitiveFlag]
		,[CRS].[SPATIENT].[Sta3n] AS [SPATIENT_Sta3n]
		,[CRS].[SPATIENT].[State] AS [SPATIENT_State]
		,[CRS].[SPATIENT].[StateIEN] AS [SPATIENT_StateIEN]
		,[CRS].[SPATIENT].[StateSID] AS [SPATIENT_StateSID]
		,[CRS].[SPATIENT].[STD_COMBATLOCATION_ID] AS [SPATIENT_STD_COMBATLOCATION_ID]
		,[CRS].[SPATIENT].[STD_ENTHNICITY_ID] AS [SPATIENT_STD_ENTHNICITY_ID]
		,[CRS].[SPATIENT].[STD_GENDER_ID] AS [SPATIENT_STD_GENDER_ID]
		,[CRS].[SPATIENT].[STD_MARITALSTATUS_ID] AS [SPATIENT_STD_MARITALSTATUS_ID]
		,[CRS].[SPATIENT].[STD_RACE_ID] AS [SPATIENT_STD_RACE_ID]
		,[CRS].[SPATIENT].[STD_SERVICEBRANCH_ID] AS [SPATIENT_STD_SERVICEBRANCH_ID]
		,[CRS].[SPATIENT].[StdRegistryId] AS [SPATIENT_StdRegistryId]
		,[CRS].[SPATIENT].[StreetAddress1] AS [SPATIENT_StreetAddress1]
		,[CRS].[SPATIENT].[StreetAddress2] AS [SPATIENT_StreetAddress2]
		,[CRS].[SPATIENT].[StreetAddress3] AS [SPATIENT_StreetAddress3]
		,[CRS].[SPATIENT].[TemporaryAddressChangeInstitutionIEN] AS [SPATIENT_TemporaryAddressChangeInstitutionIEN]
		,[CRS].[SPATIENT].[Updatedate] AS [SPATIENT_Updatedate]
		,[CRS].[SPATIENT].[UpdatedBy] AS [SPATIENT_UpdatedBy]
		,[CRS].[SPATIENT].[VeteranFlag] AS [SPATIENT_VeteranFlag]
		,[CRS].[SPATIENT].[VistaCreateDate] AS [SPATIENT_VistaCreateDate]
		,[CRS].[SPATIENT].[VistaEditDate] AS [SPATIENT_VistaEditDate]
		,ISNULL([CRS].[SPATIENT].[Zip],[CRS].[SPATIENT].[PostalCode])  AS [SPATIENT_Zip]
		,[CRS].[SPATIENT].[Zip4] AS [SPATIENT_Zip4]
		,RIGHT(ISNULL([CRS].[SPATIENT].[PatientSSN], '0000'), 4) AS [SPATIENT_PatientLastFour]

		,[CRS].[SStaff_SStaff].[City] AS [SStaff_SStaff_City]
		,[CRS].[SStaff_SStaff].[CommercialPhone] AS [SStaff_SStaff_CommercialPhone]
		,[CRS].[SStaff_SStaff].[CreatedByStaffSID] AS [SStaff_SStaff_CreatedByStaffSID]
		,[CRS].[SStaff_SStaff].[DEA] AS [SStaff_SStaff_DEA]
		,[CRS].[SStaff_SStaff].[Degree] AS [SStaff_SStaff_Degree]
		,[CRS].[SStaff_SStaff].[DelegateOfStaffIEN] AS [SStaff_SStaff_DelegateOfStaffIEN]
		,[CRS].[SStaff_SStaff].[DelegateOfStaffSID] AS [SStaff_SStaff_DelegateOfStaffSID]
		,[CRS].[SStaff_SStaff].[DelegationDate] AS [SStaff_SStaff_DelegationDate]
		,[CRS].[SStaff_SStaff].[DelegationLevel] AS [SStaff_SStaff_DelegationLevel]
		,[CRS].[SStaff_SStaff].[DigitalPager] AS [SStaff_SStaff_DigitalPager]
		,[CRS].[SStaff_SStaff].[ElectronicSignatureCodeFlag] AS [SStaff_SStaff_ElectronicSignatureCodeFlag]
		,[CRS].[SStaff_SStaff].[EmailAddress] AS [SStaff_SStaff_EmailAddress]
		,[CRS].[SStaff_SStaff].[EnteredDate] AS [SStaff_SStaff_EnteredDate]
		,[CRS].[SStaff_SStaff].[ETLBatchID] AS [SStaff_SStaff_ETLBatchID]
		,[CRS].[SStaff_SStaff].[FaxNumber] AS [SStaff_SStaff_FaxNumber]
		,[CRS].[SStaff_SStaff].[FirstName] AS [SStaff_SStaff_FirstName]
		,[CRS].[SStaff_SStaff].[Gender] AS [SStaff_SStaff_Gender]
		,[CRS].[SStaff_SStaff].[HINQEmployeeNumberFlag] AS [SStaff_SStaff_HINQEmployeeNumberFlag]
		,[CRS].[SStaff_SStaff].[HomePhone] AS [SStaff_SStaff_HomePhone]
		,[CRS].[SStaff_SStaff].[InactivationDate] AS [SStaff_SStaff_InactivationDate]
		,[CRS].[SStaff_SStaff].[LastEditedDateTime] AS [SStaff_SStaff_LastEditedDateTime]
		,[CRS].[SStaff_SStaff].[LastName] AS [SStaff_SStaff_LastName]
		,[CRS].[SStaff_SStaff].[LastSignonDateTime] AS [SStaff_SStaff_LastSignonDateTime]
		,[CRS].[SStaff_SStaff].[LastUsedTerminalType] AS [SStaff_SStaff_LastUsedTerminalType]
		,[CRS].[SStaff_SStaff].[MailCode] AS [SStaff_SStaff_MailCode]
		,[CRS].[SStaff_SStaff].[MiddleName] AS [SStaff_SStaff_MiddleName]
		,[CRS].[SStaff_SStaff].[NetworkUsername] AS [SStaff_SStaff_NetworkUsername]
		,[CRS].[SStaff_SStaff].[NPI] AS [SStaff_SStaff_NPI]
		,[CRS].[SStaff_SStaff].[NPIAuthorizedReleaseFlag] AS [SStaff_SStaff_NPIAuthorizedReleaseFlag]
		,[CRS].[SStaff_SStaff].[OfficePhone] AS [SStaff_SStaff_OfficePhone]
		,[CRS].[SStaff_SStaff].[OpCode] AS [SStaff_SStaff_OpCode]
		,[CRS].[SStaff_SStaff].[PACFlag] AS [SStaff_SStaff_PACFlag]
		,[CRS].[SStaff_SStaff].[Phone3] AS [SStaff_SStaff_Phone3]
		,[CRS].[SStaff_SStaff].[Phone4] AS [SStaff_SStaff_Phone4]
		,[CRS].[SStaff_SStaff].[PositionTitle] AS [SStaff_SStaff_PositionTitle]
		,[CRS].[SStaff_SStaff].[Provider_ID] AS [SStaff_SStaff_Provider_ID]
		,[CRS].[SStaff_SStaff].[ProviderClass] AS [SStaff_SStaff_ProviderClass]
		,[CRS].[SStaff_SStaff].[ProviderClassSID] AS [SStaff_SStaff_ProviderClassSID]
		,[CRS].[SStaff_SStaff].[ProviderScheduleType] AS [SStaff_SStaff_ProviderScheduleType]
		,[CRS].[SStaff_SStaff].[Room] AS [SStaff_SStaff_Room]
		,[CRS].[SStaff_SStaff].[ServiceComputationDate] AS [SStaff_SStaff_ServiceComputationDate]
		,[CRS].[SStaff_SStaff].[ServiceSection] AS [SStaff_SStaff_ServiceSection]
		,[CRS].[SStaff_SStaff].[ServiceSectionSID] AS [SStaff_SStaff_ServiceSectionSID]
		,[CRS].[SStaff_SStaff].[ServiceType] AS [SStaff_SStaff_ServiceType]
		,[CRS].[SStaff_SStaff].[SignatureBlockName] AS [SStaff_SStaff_SignatureBlockName]
		,[CRS].[SStaff_SStaff].[SignatureBlockTitle] AS [SStaff_SStaff_SignatureBlockTitle]
		,[CRS].[SStaff_SStaff].[SocialWorkerImmediateSupervisorStaffSID] AS [SStaff_SStaff_SocialWorkerImmediateSupervisorStaffSID]
		,[CRS].[SStaff_SStaff].[SocialWorkerPositionTitle] AS [SStaff_SStaff_SocialWorkerPositionTitle]
		,[CRS].[SStaff_SStaff].[Sta3n] AS [SStaff_SStaff_Sta3n]
		,[CRS].[SStaff_SStaff].[StaffIEN] AS [SStaff_SStaff_StaffIEN]
		,[CRS].[SStaff_SStaff].[StaffName] AS [SStaff_SStaff_StaffName]
		,[CRS].[SStaff_SStaff].[StaffNamePrefix] AS [SStaff_SStaff_StaffNamePrefix]
		,[CRS].[SStaff_SStaff].[StaffNameSuffix] AS [SStaff_SStaff_StaffNameSuffix]
		,[CRS].[SStaff_SStaff].[StaffSID] AS [SStaff_SStaff_StaffSID]
		,[CRS].[SStaff_SStaff].[StateName] AS [SStaff_SStaff_StateName]
		,[CRS].[SStaff_SStaff].[StreetAddress1] AS [SStaff_SStaff_StreetAddress1]
		,[CRS].[SStaff_SStaff].[StreetAddress2] AS [SStaff_SStaff_StreetAddress2]
		,[CRS].[SStaff_SStaff].[StreetAddress3] AS [SStaff_SStaff_StreetAddress3]
		,[CRS].[SStaff_SStaff].[SupplyEmployee] AS [SStaff_SStaff_SupplyEmployee]
		,[CRS].[SStaff_SStaff].[TemporaryAddress1] AS [SStaff_SStaff_TemporaryAddress1]
		,[CRS].[SStaff_SStaff].[TemporaryAddress2] AS [SStaff_SStaff_TemporaryAddress2]
		,[CRS].[SStaff_SStaff].[TemporaryAddress3] AS [SStaff_SStaff_TemporaryAddress3]
		,[CRS].[SStaff_SStaff].[TemporaryAddressEndDate] AS [SStaff_SStaff_TemporaryAddressEndDate]
		,[CRS].[SStaff_SStaff].[TemporaryAddressStartDate] AS [SStaff_SStaff_TemporaryAddressStartDate]
		,[CRS].[SStaff_SStaff].[TemporaryCity] AS [SStaff_SStaff_TemporaryCity]
		,[CRS].[SStaff_SStaff].[TemporaryStateName] AS [SStaff_SStaff_TemporaryStateName]
		,[CRS].[SStaff_SStaff].[TemporaryZipCode] AS [SStaff_SStaff_TemporaryZipCode]
		,[CRS].[SStaff_SStaff].[TerminationDate] AS [SStaff_SStaff_TerminationDate]
		,[CRS].[SStaff_SStaff].[TerminationReason] AS [SStaff_SStaff_TerminationReason]
		,[CRS].[SStaff_SStaff].[VANumber] AS [SStaff_SStaff_VANumber]
		,[CRS].[SStaff_SStaff].[VerifyCodeLastChangedDate] AS [SStaff_SStaff_VerifyCodeLastChangedDate]
		,[CRS].[SStaff_SStaff].[VistaCreateDate] AS [SStaff_SStaff_VistaCreateDate]
		,[CRS].[SStaff_SStaff].[VistaEditDate] AS [SStaff_SStaff_VistaEditDate]
		,[CRS].[SStaff_SStaff].[VoicePager] AS [SStaff_SStaff_VoicePager]
		,[CRS].[SStaff_SStaff].[ZipCode] AS [SStaff_SStaff_ZipCode]
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[STD_REFERRALSTS] ON [CRS].[STD_REFERRALSTS].[ID] = [CRS].[REFERRAL].[STD_REFERRALSTS_ID]
			LEFT OUTER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			LEFT OUTER JOIN [CRS].[SStaff_SStaff] ON [CRS].[SStaff_SStaff].[Provider_ID] = [CRS].[REFERRAL].[Provider_ID] 
	WHERE [CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID;
END

GO

-- =============================================
-- Author:        
-- Create date:   12/28/2015
-- Description:   Get all records by Patient
---               Updated Stored Procedure to Display either Zip or PostalCode from SPATIENT table.
-- =============================================
ALTER PROCEDURE [CRS].[usp_REFERRAL_getitemsByPatient] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @PATIENT_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_REFERRAL_getitemsByPatient', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT * FROM (
	SELECT 
		ROW_NUMBER() OVER(PARTITION BY [CRS].[REFERRAL].[REFERRAL_ID] ORDER BY [CRS].[REFERRAL].[REFERRAL_ID] DESC) AS [Row]
		,[CRS].[REFERRAL].[PROVIDER_ID] AS [REFERRAL_PROVIDER_ID]
		,[CRS].[REFERRAL].[REFERRAL_DATE] AS [REFERRAL_REFERRAL_DATE]
		,[CRS].[REFERRAL].[REFERRAL_ID] AS [REFERRAL_REFERRAL_ID]
		,[CRS].[REFERRAL].[PATIENT_ID] AS [REFERRAL_PATIENT_ID]

		,[CRS].[STD_REGISTRY].[NAME] AS [STD_REGISTRY_NAME]

		,[CRS].[PATIENT].[BIRTH_DATE] AS [PATIENT_BIRTH_DATE]
		,[CRS].[PATIENT].[FIRST_NAME] AS [PATIENT_FIRST_NAME]
		,[CRS].[PATIENT].[LAST_NAME] AS [PATIENT_LAST_NAME]

		,[CRS].[STD_REFERRALSTS].[CODE] AS [STD_REFERRALSTS_CODE]

		,[CRS].[SPATIENT].[City] AS [SPATIENT_City]
		,[CRS].[SPATIENT].[Gender] AS [SPATIENT_Gender]
		,ISNULL([CRS].[SPATIENT].[PostalCode],[CRS].[SPATIENT].[Zip]) AS [SPATIENT_PostalCode]
		
		,[CRS].[SPATIENT].[State] AS [SPATIENT_State]
		,RIGHT(ISNULL([CRS].[SPATIENT].[PatientSSN], '0000'), 4) AS [SPATIENT_PatientLastFour]
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[STD_REFERRALSTS] ON [CRS].[STD_REFERRALSTS].[ID] = [CRS].[REFERRAL].[STD_REFERRALSTS_ID]
			LEFT OUTER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
	WHERE 
		[CRS].[REFERRAL].[PATIENT_ID] = @PATIENT_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0) t WHERE t.[Row] = 1;
END


GO

-- =============================================
-- Author:        
-- Create date:   12/28/2015
-- Description:   Get all records by Provider
---               Updated Stored Procedure to Display either Zip or PostalCode from SPATIENT table.
-- =============================================
ALTER PROCEDURE [CRS].[usp_REFERRAL_getitemsByProvider] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @PROVIDER_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_REFERRAL_getitemsByProvider', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT * FROM (
	SELECT 
		ROW_NUMBER() OVER(PARTITION BY [CRS].[REFERRAL].[REFERRAL_ID] ORDER BY [CRS].[REFERRAL].[REFERRAL_ID] DESC) AS [Row]
		,[CRS].[REFERRAL].[PROVIDER_ID] AS [REFERRAL_PROVIDER_ID]
		,[CRS].[REFERRAL].[REFERRAL_DATE] AS [REFERRAL_REFERRAL_DATE]
		,[CRS].[REFERRAL].[REFERRAL_ID] AS [REFERRAL_REFERRAL_ID]
		,[CRS].[REFERRAL].[PATIENT_ID] AS [REFERRAL_PATIENT_ID]

		,[CRS].[STD_REGISTRY].[NAME] AS [STD_REGISTRY_NAME]

		,[CRS].[PATIENT].[BIRTH_DATE] AS [PATIENT_BIRTH_DATE]
		,[CRS].[PATIENT].[FIRST_NAME] AS [PATIENT_FIRST_NAME]
		,[CRS].[PATIENT].[LAST_NAME] AS [PATIENT_LAST_NAME]

		,[CRS].[STD_REFERRALSTS].[CODE] AS [STD_REFERRALSTS_CODE]

		,[CRS].[SPATIENT].[City] AS [SPATIENT_City]
		,[CRS].[SPATIENT].[Gender] AS [SPATIENT_Gender]
		,ISNULL([CRS].[SPATIENT].[PostalCode],[CRS].[SPATIENT].[Zip])  AS [SPATIENT_PostalCode]
		,[CRS].[SPATIENT].[State] AS [SPATIENT_State]
		,RIGHT(ISNULL([CRS].[SPATIENT].[PatientSSN], '0000'), 4) AS [SPATIENT_PatientLastFour]
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[STD_REFERRALSTS] ON [CRS].[STD_REFERRALSTS].[ID] = [CRS].[REFERRAL].[STD_REFERRALSTS_ID]
			LEFT OUTER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			LEFT OUTER JOIN [CRS].[SStaff_SStaff] ON [CRS].[SStaff_SStaff].[Provider_ID] = [CRS].[REFERRAL].[Provider_ID]
	WHERE 
		[CRS].[REFERRAL].[PROVIDER_ID] = @PROVIDER_ID) t WHERE t.[Row] = 1;
END



GO

-- =============================================
-- Author:        
-- Create date:   12/28/2015
-- Description:   Get all records by Registry and Status
---               Updated Stored Procedure to Display either Zip or PostalCode from SPATIENT table.
-- =============================================
ALTER PROCEDURE [CRS].[usp_REFERRAL_getitemsByRegistryStatus] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @STD_REFERRALSTS_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_REFERRAL_getitemsByRegistryStatus', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT 
		[CRS].[REFERRAL].[COMMENT_TEXT] AS [REFERRAL_COMMENT_TEXT]
		,[CRS].[REFERRAL].[CREATED] AS [REFERRAL_CREATED]
		,[CRS].[REFERRAL].[CREATEDBY] AS [REFERRAL_CREATEDBY]
		,[CRS].[REFERRAL].[CREATEDSOURCE] AS [REFERRAL_CREATEDSOURCE]
		,[CRS].[REFERRAL].[DUPLICATE_FLAG] AS [REFERRAL_DUPLICATE_FLAG]
		,[CRS].[REFERRAL].[PATIENT_ID] AS [REFERRAL_PATIENT_ID]
		,[CRS].[REFERRAL].[PROVIDER_ID] AS [REFERRAL_PROVIDER_ID]
		,[CRS].[REFERRAL].[REFERRAL_CLASS_TEXT] AS [REFERRAL_REFERRAL_CLASS_TEXT]
		,[CRS].[REFERRAL].[REFERRAL_DATE] AS [REFERRAL_REFERRAL_DATE]
		,[CRS].[REFERRAL].[REFERRAL_ID] AS [REFERRAL_REFERRAL_ID]
		,[CRS].[REFERRAL].[REVIEW_BY] AS [REFERRAL_REVIEW_BY]
		,[CRS].[REFERRAL].[REVIEW_DATE] AS [REFERRAL_REVIEW_DATE]
		,[CRS].[REFERRAL].[STD_REFERRALSTS_ID] AS [REFERRAL_STD_REFERRALSTS_ID]
		,[CRS].[REFERRAL].[STD_REGISTRY_ID] AS [REFERRAL_STD_REGISTRY_ID]
		,[CRS].[REFERRAL].[STD_REMINDERCLASS_ID] AS [REFERRAL_STD_REMINDERCLASS_ID]
		,[CRS].[REFERRAL].[UPDATED] AS [REFERRAL_UPDATED]
		,[CRS].[REFERRAL].[UPDATEDBY] AS [REFERRAL_UPDATEDBY]
		,[CRS].[REFERRAL].[UPDATEDSOURCE] AS [REFERRAL_UPDATEDSOURCE]

		,[CRS].[STD_REGISTRY].[CODE] AS [STD_REGISTRY_CODE]
		,[CRS].[STD_REGISTRY].[COMMENTS] AS [STD_REGISTRY_COMMENTS]
		,[CRS].[STD_REGISTRY].[CREATED] AS [STD_REGISTRY_CREATED]
		,[CRS].[STD_REGISTRY].[CREATEDBY] AS [STD_REGISTRY_CREATEDBY]
		,[CRS].[STD_REGISTRY].[DESCRIPTION_TEXT] AS [STD_REGISTRY_DESCRIPTION_TEXT]
		,[CRS].[STD_REGISTRY].[ID] AS [STD_REGISTRY_ID]
		,[CRS].[STD_REGISTRY].[INACTIVE_DATE] AS [STD_REGISTRY_INACTIVE_DATE]
		,[CRS].[STD_REGISTRY].[INACTIVE_FLAG] AS [STD_REGISTRY_INACTIVE_FLAG]
		,[CRS].[STD_REGISTRY].[NAME] AS [STD_REGISTRY_NAME]
		,[CRS].[STD_REGISTRY].[REGISTRY_ADMINISTRATOR] AS [STD_REGISTRY_REGISTRY_ADMINISTRATOR]
		,[CRS].[STD_REGISTRY].[REGISTRY_OWNER] AS [STD_REGISTRY_REGISTRY_OWNER]
		,[CRS].[STD_REGISTRY].[REGISTRY_SUPPORT_CONTACT] AS [STD_REGISTRY_REGISTRY_SUPPORT_CONTACT]
		,[CRS].[STD_REGISTRY].[SORT_ORDER] AS [STD_REGISTRY_SORT_ORDER]
		,[CRS].[STD_REGISTRY].[UPDATED] AS [STD_REGISTRY_UPDATED]
		,[CRS].[STD_REGISTRY].[UPDATEDBY] AS [STD_REGISTRY_UPDATEDBY]

		,[CRS].[PATIENT].[BIRTH_DATE] AS [PATIENT_BIRTH_DATE]
		,[CRS].[PATIENT].[CELL_PHONE] AS [PATIENT_CELL_PHONE]
		,[CRS].[PATIENT].[CREATED] AS [PATIENT_CREATED]
		,[CRS].[PATIENT].[CREATEDBY] AS [PATIENT_CREATEDBY]
		,[CRS].[PATIENT].[DEATH_DATE] AS [PATIENT_DEATH_DATE]
		,[CRS].[PATIENT].[EMAIL_ADDRESS] AS [PATIENT_EMAIL_ADDRESS]
		,[CRS].[PATIENT].[FIRST_NAME] AS [PATIENT_FIRST_NAME]
		,[CRS].[PATIENT].[LAST_NAME] AS [PATIENT_LAST_NAME]
		,[CRS].[PATIENT].[MIDDLE_NAME] AS [PATIENT_MIDDLE_NAME]
		,[CRS].[PATIENT].[OEFOIF_IND] AS [PATIENT_OEFOIF_IND]
		,[CRS].[PATIENT].[PATIENT_ID] AS [PATIENT_PATIENT_ID]
		,[CRS].[PATIENT].[PATIENTSID] AS [PATIENT_PATIENTSID]
		,[CRS].[PATIENT].[PERFERRED_ADDRESS_TYPE] AS [PATIENT_PERFERRED_ADDRESS_TYPE]
		,[CRS].[PATIENT].[UPDATED] AS [PATIENT_UPDATED]
		,[CRS].[PATIENT].[UPDATEDBY] AS [PATIENT_UPDATEDBY]
		,[CRS].[PATIENT].[PatientICN] AS [PATIENT_PatientICN]

		,[CRS].[STD_REFERRALSTS].[CODE] AS [STD_REFERRALSTS_CODE]
		,[CRS].[STD_REFERRALSTS].[CREATED] AS [STD_REFERRALSTS_CREATED]
		,[CRS].[STD_REFERRALSTS].[CREATEDBY] AS [STD_REFERRALSTS_CREATEDBY]
		,[CRS].[STD_REFERRALSTS].[DESCRIPTION_TEXT] AS [STD_REFERRALSTS_DESCRIPTION_TEXT]
		,[CRS].[STD_REFERRALSTS].[ID] AS [STD_REFERRALSTS_ID]
		,[CRS].[STD_REFERRALSTS].[INACTIVE_DATE] AS [STD_REFERRALSTS_INACTIVE_DATE]
		,[CRS].[STD_REFERRALSTS].[INACTIVE_FLAG] AS [STD_REFERRALSTS_INACTIVE_FLAG]
		,[CRS].[STD_REFERRALSTS].[NAME] AS [STD_REFERRALSTS_NAME]
		,[CRS].[STD_REFERRALSTS].[SORT_ORDER] AS [STD_REFERRALSTS_SORT_ORDER]
		,[CRS].[STD_REFERRALSTS].[STD_REGISTRY_ID] AS [STD_REFERRALSTS_STD_REGISTRY_ID]
		,[CRS].[STD_REFERRALSTS].[UPDATED] AS [STD_REFERRALSTS_UPDATED]
		,[CRS].[STD_REFERRALSTS].[UPDATEDBY] AS [STD_REFERRALSTS_UPDATEDBY]

		,[CRS].[SPATIENT].[AddressChangeInstitutionIEN] AS [SPATIENT_AddressChangeInstitutionIEN]
		,[CRS].[SPATIENT].[AddressChangeInstitutionSID] AS [SPATIENT_AddressChangeInstitutionSID]
		,[CRS].[SPATIENT].[AddressChangeStaffIEN] AS [SPATIENT_AddressChangeStaffIEN]
		,[CRS].[SPATIENT].[AddressChangeStaffSID] AS [SPATIENT_AddressChangeStaffSID]
		,[CRS].[SPATIENT].[Age] AS [SPATIENT_Age]
		,[CRS].[SPATIENT].[BadAddressIndicator] AS [SPATIENT_BadAddressIndicator]
		,[CRS].[SPATIENT].[CDDeterminingInstitutionIEN] AS [SPATIENT_CDDeterminingInstitutionIEN]
		,[CRS].[SPATIENT].[City] AS [SPATIENT_City]
		,[CRS].[SPATIENT].[CombatFromVistaDate] AS [SPATIENT_CombatFromVistaDate]
		,[CRS].[SPATIENT].[CombatToVistaDate] AS [SPATIENT_CombatToVistaDate]
		,[CRS].[SPATIENT].[ConfidentialAddressActiveFlag] AS [SPATIENT_ConfidentialAddressActiveFlag]
		,[CRS].[SPATIENT].[Country] AS [SPATIENT_Country]
		,[CRS].[SPATIENT].[CountryIEN] AS [SPATIENT_CountryIEN]
		,[CRS].[SPATIENT].[CountrySID] AS [SPATIENT_CountrySID]
		,[CRS].[SPATIENT].[County] AS [SPATIENT_County]
		,[CRS].[SPATIENT].[Created] AS [SPATIENT_Created]
		,[CRS].[SPATIENT].[CreatedBy] AS [SPATIENT_CreatedBy]
		,[CRS].[SPATIENT].[CurrentMeansTestStatusIEN] AS [SPATIENT_CurrentMeansTestStatusIEN]
		,[CRS].[SPATIENT].[DateOfBirth] AS [SPATIENT_DateOfBirth]
		,[CRS].[SPATIENT].[DateOfBirthText] AS [SPATIENT_DateOfBirthText]
		,[CRS].[SPATIENT].[DateOfDeath] AS [SPATIENT_DateOfDeath]
		,[CRS].[SPATIENT].[DateOfDeathText] AS [SPATIENT_DateOfDeathText]
		,[CRS].[SPATIENT].[Deceased] AS [SPATIENT_Deceased]
		,[CRS].[SPATIENT].[DEFAULT_RECORD] AS [SPATIENT_DEFAULT_RECORD]
		,[CRS].[SPATIENT].[Eligibility] AS [SPATIENT_Eligibility]
		,[CRS].[SPATIENT].[EligibilityIEN] AS [SPATIENT_EligibilityIEN]
		,[CRS].[SPATIENT].[EligibilitySID] AS [SPATIENT_EligibilitySID]
		,[CRS].[SPATIENT].[EligibilityStatus] AS [SPATIENT_EligibilityStatus]
		,[CRS].[SPATIENT].[EligibilityVACode] AS [SPATIENT_EligibilityVACode]
		,[CRS].[SPATIENT].[EligibilityVerificationSource] AS [SPATIENT_EligibilityVerificationSource]
		,[CRS].[SPATIENT].[EmailAddress] AS [SPATIENT_EmailAddress]
		,[CRS].[SPATIENT].[EnteredIntoFileDate] AS [SPATIENT_EnteredIntoFileDate]
		,[CRS].[SPATIENT].[EnteredIntoFileDateTransformSID] AS [SPATIENT_EnteredIntoFileDateTransformSID]
		,[CRS].[SPATIENT].[EnteredIntoFileVistaErrorDate] AS [SPATIENT_EnteredIntoFileVistaErrorDate]
		,[CRS].[SPATIENT].[ETLBatchID] AS [SPATIENT_ETLBatchID]
		,[CRS].[SPATIENT].[ExcludeFromFacilityDirectoryFlag] AS [SPATIENT_ExcludeFromFacilityDirectoryFlag]
		,[CRS].[SPATIENT].[Gender] AS [SPATIENT_Gender]
		,[CRS].[SPATIENT].[GISAddressType] AS [SPATIENT_GISAddressType]
		,[CRS].[SPATIENT].[GISAddressUpdatedDate] AS [SPATIENT_GISAddressUpdatedDate]
		,[CRS].[SPATIENT].[GISCongressDistrict] AS [SPATIENT_GISCongressDistrict]
		,[CRS].[SPATIENT].[GISFIPSCode] AS [SPATIENT_GISFIPSCode]
		,[CRS].[SPATIENT].[GISLocatorName] AS [SPATIENT_GISLocatorName]
		,[CRS].[SPATIENT].[GISMarket] AS [SPATIENT_GISMarket]
		,[CRS].[SPATIENT].[GISMatchedAddress] AS [SPATIENT_GISMatchedAddress]
		,[CRS].[SPATIENT].[GISMatchMethodCode] AS [SPATIENT_GISMatchMethodCode]
		,[CRS].[SPATIENT].[GISMatchScore] AS [SPATIENT_GISMatchScore]
		,[CRS].[SPATIENT].[GISMatchStatusCode] AS [SPATIENT_GISMatchStatusCode]
		,[CRS].[SPATIENT].[GISPatientAddressLatitude] AS [SPATIENT_GISPatientAddressLatitude]
		,[CRS].[SPATIENT].[GISPatientAddressLongitude] AS [SPATIENT_GISPatientAddressLongitude]
		,[CRS].[SPATIENT].[GISSector] AS [SPATIENT_GISSector]
		,[CRS].[SPATIENT].[GISStreetSide] AS [SPATIENT_GISStreetSide]
		,[CRS].[SPATIENT].[GISSubmarket] AS [SPATIENT_GISSubmarket]
		,[CRS].[SPATIENT].[GISURH] AS [SPATIENT_GISURH]
		,[CRS].[SPATIENT].[InsuranceCoverageFlag] AS [SPATIENT_InsuranceCoverageFlag]
		,[CRS].[SPATIENT].[LastServiceEntryDate] AS [SPATIENT_LastServiceEntryDate]
		,[CRS].[SPATIENT].[LastServiceEntryDateTransformSID] AS [SPATIENT_LastServiceEntryDateTransformSID]
		,[CRS].[SPATIENT].[LastServiceEntryVistaErrorDate] AS [SPATIENT_LastServiceEntryVistaErrorDate]
		,[CRS].[SPATIENT].[LastServiceSeparationDate] AS [SPATIENT_LastServiceSeparationDate]
		,[CRS].[SPATIENT].[LastServiceSeparationDateTransformSID] AS [SPATIENT_LastServiceSeparationDateTransformSID]
		,[CRS].[SPATIENT].[LastServiceSeparationVistaErrorDate] AS [SPATIENT_LastServiceSeparationVistaErrorDate]
		,[CRS].[SPATIENT].[MaritalStatus] AS [SPATIENT_MaritalStatus]
		,[CRS].[SPATIENT].[MaritalStatusIEN] AS [SPATIENT_MaritalStatusIEN]
		,[CRS].[SPATIENT].[MaritalStatusSID] AS [SPATIENT_MaritalStatusSID]
		,[CRS].[SPATIENT].[MedicaidNumber] AS [SPATIENT_MedicaidNumber]
		,[CRS].[SPATIENT].[MothersMaidenName] AS [SPATIENT_MothersMaidenName]
		,[CRS].[SPATIENT].[OEF_OIF_IND] AS [SPATIENT_OEF_OIF_IND]
		,[CRS].[SPATIENT].[OpCode] AS [SPATIENT_OpCode]
		,[CRS].[SPATIENT].[Patient_ID] AS [SPATIENT_Patient_ID]
		,[CRS].[SPATIENT].[PatientFirstName] AS [SPATIENT_PatientFirstName]
		,[CRS].[SPATIENT].[PatientICN] AS [SPATIENT_PatientICN]
		,[CRS].[SPATIENT].[PatientICNChecksum] AS [SPATIENT_PatientICNChecksum]
		,[CRS].[SPATIENT].[PatientIEN] AS [SPATIENT_PatientIEN]
		,[CRS].[SPATIENT].[PatientLastName] AS [SPATIENT_PatientLastName]
		,[CRS].[SPATIENT].[PatientName] AS [SPATIENT_PatientName]
		,[CRS].[SPATIENT].[PatientSID] AS [SPATIENT_PatientSID]
		,[CRS].[SPATIENT].[PatientSSN] AS [SPATIENT_PatientSSN]
		,[CRS].[SPATIENT].[PercentServiceConnect] AS [SPATIENT_PercentServiceConnect]
		,[CRS].[SPATIENT].[PeriodOfService] AS [SPATIENT_PeriodOfService]
		,[CRS].[SPATIENT].[PeriodOfServiceIEN] AS [SPATIENT_PeriodOfServiceIEN]
		,[CRS].[SPATIENT].[PeriodOfServiceSID] AS [SPATIENT_PeriodOfServiceSID]
		,[CRS].[SPATIENT].[PhoneCellular] AS [SPATIENT_PhoneCellular]
		,[CRS].[SPATIENT].[PhoneResidence] AS [SPATIENT_PhoneResidence]
		,[CRS].[SPATIENT].[PhoneWork] AS [SPATIENT_PhoneWork]
		,[CRS].[SPATIENT].[PK_ID] AS [SPATIENT_PK_ID]
		,ISNULL([CRS].[SPATIENT].[PostalCode],[CRS].[SPATIENT].[Zip])  AS [SPATIENT_PostalCode]
		,[CRS].[SPATIENT].[POWLocationIEN] AS [SPATIENT_POWLocationIEN]
		,[CRS].[SPATIENT].[PreferredInstitutionIEN] AS [SPATIENT_PreferredInstitutionIEN]
		,[CRS].[SPATIENT].[Province] AS [SPATIENT_Province]
		,[CRS].[SPATIENT].[PseudoSSNFlag] AS [SPATIENT_PseudoSSNFlag]
		,[CRS].[SPATIENT].[PurpleHeartInstitutionIEN] AS [SPATIENT_PurpleHeartInstitutionIEN]
		,[CRS].[SPATIENT].[Race] AS [SPATIENT_Race]
		,[CRS].[SPATIENT].[RaceIEN] AS [SPATIENT_RaceIEN]
		,[CRS].[SPATIENT].[RaceSID] AS [SPATIENT_RaceSID]
		,[CRS].[SPATIENT].[Religion] AS [SPATIENT_Religion]
		,[CRS].[SPATIENT].[ReligionIEN] AS [SPATIENT_ReligionIEN]
		,[CRS].[SPATIENT].[ReligionSID] AS [SPATIENT_ReligionSID]
		,[CRS].[SPATIENT].[RoomBedIEN] AS [SPATIENT_RoomBedIEN]
		,[CRS].[SPATIENT].[ScrSSN] AS [SPATIENT_ScrSSN]
		,[CRS].[SPATIENT].[SensitiveFlag] AS [SPATIENT_SensitiveFlag]
		,[CRS].[SPATIENT].[Sta3n] AS [SPATIENT_Sta3n]
		,[CRS].[SPATIENT].[State] AS [SPATIENT_State]
		,[CRS].[SPATIENT].[StateIEN] AS [SPATIENT_StateIEN]
		,[CRS].[SPATIENT].[StateSID] AS [SPATIENT_StateSID]
		,[CRS].[SPATIENT].[STD_COMBATLOCATION_ID] AS [SPATIENT_STD_COMBATLOCATION_ID]
		,[CRS].[SPATIENT].[STD_ENTHNICITY_ID] AS [SPATIENT_STD_ENTHNICITY_ID]
		,[CRS].[SPATIENT].[STD_GENDER_ID] AS [SPATIENT_STD_GENDER_ID]
		,[CRS].[SPATIENT].[STD_MARITALSTATUS_ID] AS [SPATIENT_STD_MARITALSTATUS_ID]
		,[CRS].[SPATIENT].[STD_RACE_ID] AS [SPATIENT_STD_RACE_ID]
		,[CRS].[SPATIENT].[STD_SERVICEBRANCH_ID] AS [SPATIENT_STD_SERVICEBRANCH_ID]
		,[CRS].[SPATIENT].[StdRegistryId] AS [SPATIENT_StdRegistryId]
		,[CRS].[SPATIENT].[StreetAddress1] AS [SPATIENT_StreetAddress1]
		,[CRS].[SPATIENT].[StreetAddress2] AS [SPATIENT_StreetAddress2]
		,[CRS].[SPATIENT].[StreetAddress3] AS [SPATIENT_StreetAddress3]
		,[CRS].[SPATIENT].[TemporaryAddressChangeInstitutionIEN] AS [SPATIENT_TemporaryAddressChangeInstitutionIEN]
		,[CRS].[SPATIENT].[Updatedate] AS [SPATIENT_Updatedate]
		,[CRS].[SPATIENT].[UpdatedBy] AS [SPATIENT_UpdatedBy]
		,[CRS].[SPATIENT].[VeteranFlag] AS [SPATIENT_VeteranFlag]
		,[CRS].[SPATIENT].[VistaCreateDate] AS [SPATIENT_VistaCreateDate]
		,[CRS].[SPATIENT].[VistaEditDate] AS [SPATIENT_VistaEditDate]
		,ISNULL([CRS].[SPATIENT].[Zip],[CRS].[SPATIENT].[PostalCode])  AS [SPATIENT_Zip]
		,[CRS].[SPATIENT].[Zip4] AS [SPATIENT_Zip4]
		,RIGHT(ISNULL([CRS].[SPATIENT].[PatientSSN], '0000'), 4) AS [SPATIENT_PatientLastFour]

		,[CRS].[SStaff_SStaff].[City] AS [SStaff_SStaff_City]
		,[CRS].[SStaff_SStaff].[CommercialPhone] AS [SStaff_SStaff_CommercialPhone]
		,[CRS].[SStaff_SStaff].[CreatedByStaffSID] AS [SStaff_SStaff_CreatedByStaffSID]
		,[CRS].[SStaff_SStaff].[DEA] AS [SStaff_SStaff_DEA]
		,[CRS].[SStaff_SStaff].[Degree] AS [SStaff_SStaff_Degree]
		,[CRS].[SStaff_SStaff].[DelegateOfStaffIEN] AS [SStaff_SStaff_DelegateOfStaffIEN]
		,[CRS].[SStaff_SStaff].[DelegateOfStaffSID] AS [SStaff_SStaff_DelegateOfStaffSID]
		,[CRS].[SStaff_SStaff].[DelegationDate] AS [SStaff_SStaff_DelegationDate]
		,[CRS].[SStaff_SStaff].[DelegationLevel] AS [SStaff_SStaff_DelegationLevel]
		,[CRS].[SStaff_SStaff].[DigitalPager] AS [SStaff_SStaff_DigitalPager]
		,[CRS].[SStaff_SStaff].[ElectronicSignatureCodeFlag] AS [SStaff_SStaff_ElectronicSignatureCodeFlag]
		,[CRS].[SStaff_SStaff].[EmailAddress] AS [SStaff_SStaff_EmailAddress]
		,[CRS].[SStaff_SStaff].[EnteredDate] AS [SStaff_SStaff_EnteredDate]
		,[CRS].[SStaff_SStaff].[ETLBatchID] AS [SStaff_SStaff_ETLBatchID]
		,[CRS].[SStaff_SStaff].[FaxNumber] AS [SStaff_SStaff_FaxNumber]
		,[CRS].[SStaff_SStaff].[FirstName] AS [SStaff_SStaff_FirstName]
		,[CRS].[SStaff_SStaff].[Gender] AS [SStaff_SStaff_Gender]
		,[CRS].[SStaff_SStaff].[HINQEmployeeNumberFlag] AS [SStaff_SStaff_HINQEmployeeNumberFlag]
		,[CRS].[SStaff_SStaff].[HomePhone] AS [SStaff_SStaff_HomePhone]
		,[CRS].[SStaff_SStaff].[InactivationDate] AS [SStaff_SStaff_InactivationDate]
		,[CRS].[SStaff_SStaff].[LastEditedDateTime] AS [SStaff_SStaff_LastEditedDateTime]
		,[CRS].[SStaff_SStaff].[LastName] AS [SStaff_SStaff_LastName]
		,[CRS].[SStaff_SStaff].[LastSignonDateTime] AS [SStaff_SStaff_LastSignonDateTime]
		,[CRS].[SStaff_SStaff].[LastUsedTerminalType] AS [SStaff_SStaff_LastUsedTerminalType]
		,[CRS].[SStaff_SStaff].[MailCode] AS [SStaff_SStaff_MailCode]
		,[CRS].[SStaff_SStaff].[MiddleName] AS [SStaff_SStaff_MiddleName]
		,[CRS].[SStaff_SStaff].[NetworkUsername] AS [SStaff_SStaff_NetworkUsername]
		,[CRS].[SStaff_SStaff].[NPI] AS [SStaff_SStaff_NPI]
		,[CRS].[SStaff_SStaff].[NPIAuthorizedReleaseFlag] AS [SStaff_SStaff_NPIAuthorizedReleaseFlag]
		,[CRS].[SStaff_SStaff].[OfficePhone] AS [SStaff_SStaff_OfficePhone]
		,[CRS].[SStaff_SStaff].[OpCode] AS [SStaff_SStaff_OpCode]
		,[CRS].[SStaff_SStaff].[PACFlag] AS [SStaff_SStaff_PACFlag]
		,[CRS].[SStaff_SStaff].[Phone3] AS [SStaff_SStaff_Phone3]
		,[CRS].[SStaff_SStaff].[Phone4] AS [SStaff_SStaff_Phone4]
		,[CRS].[SStaff_SStaff].[PositionTitle] AS [SStaff_SStaff_PositionTitle]
		,[CRS].[SStaff_SStaff].[Provider_ID] AS [SStaff_SStaff_Provider_ID]
		,[CRS].[SStaff_SStaff].[ProviderClass] AS [SStaff_SStaff_ProviderClass]
		,[CRS].[SStaff_SStaff].[ProviderClassSID] AS [SStaff_SStaff_ProviderClassSID]
		,[CRS].[SStaff_SStaff].[ProviderScheduleType] AS [SStaff_SStaff_ProviderScheduleType]
		,[CRS].[SStaff_SStaff].[Room] AS [SStaff_SStaff_Room]
		,[CRS].[SStaff_SStaff].[ServiceComputationDate] AS [SStaff_SStaff_ServiceComputationDate]
		,[CRS].[SStaff_SStaff].[ServiceSection] AS [SStaff_SStaff_ServiceSection]
		,[CRS].[SStaff_SStaff].[ServiceSectionSID] AS [SStaff_SStaff_ServiceSectionSID]
		,[CRS].[SStaff_SStaff].[ServiceType] AS [SStaff_SStaff_ServiceType]
		,[CRS].[SStaff_SStaff].[SignatureBlockName] AS [SStaff_SStaff_SignatureBlockName]
		,[CRS].[SStaff_SStaff].[SignatureBlockTitle] AS [SStaff_SStaff_SignatureBlockTitle]
		,[CRS].[SStaff_SStaff].[SocialWorkerImmediateSupervisorStaffSID] AS [SStaff_SStaff_SocialWorkerImmediateSupervisorStaffSID]
		,[CRS].[SStaff_SStaff].[SocialWorkerPositionTitle] AS [SStaff_SStaff_SocialWorkerPositionTitle]
		,[CRS].[SStaff_SStaff].[Sta3n] AS [SStaff_SStaff_Sta3n]
		,[CRS].[SStaff_SStaff].[StaffIEN] AS [SStaff_SStaff_StaffIEN]
		,[CRS].[SStaff_SStaff].[StaffName] AS [SStaff_SStaff_StaffName]
		,[CRS].[SStaff_SStaff].[StaffNamePrefix] AS [SStaff_SStaff_StaffNamePrefix]
		,[CRS].[SStaff_SStaff].[StaffNameSuffix] AS [SStaff_SStaff_StaffNameSuffix]
		,[CRS].[SStaff_SStaff].[StaffSID] AS [SStaff_SStaff_StaffSID]
		,[CRS].[SStaff_SStaff].[StateName] AS [SStaff_SStaff_StateName]
		,[CRS].[SStaff_SStaff].[StreetAddress1] AS [SStaff_SStaff_StreetAddress1]
		,[CRS].[SStaff_SStaff].[StreetAddress2] AS [SStaff_SStaff_StreetAddress2]
		,[CRS].[SStaff_SStaff].[StreetAddress3] AS [SStaff_SStaff_StreetAddress3]
		,[CRS].[SStaff_SStaff].[SupplyEmployee] AS [SStaff_SStaff_SupplyEmployee]
		,[CRS].[SStaff_SStaff].[TemporaryAddress1] AS [SStaff_SStaff_TemporaryAddress1]
		,[CRS].[SStaff_SStaff].[TemporaryAddress2] AS [SStaff_SStaff_TemporaryAddress2]
		,[CRS].[SStaff_SStaff].[TemporaryAddress3] AS [SStaff_SStaff_TemporaryAddress3]
		,[CRS].[SStaff_SStaff].[TemporaryAddressEndDate] AS [SStaff_SStaff_TemporaryAddressEndDate]
		,[CRS].[SStaff_SStaff].[TemporaryAddressStartDate] AS [SStaff_SStaff_TemporaryAddressStartDate]
		,[CRS].[SStaff_SStaff].[TemporaryCity] AS [SStaff_SStaff_TemporaryCity]
		,[CRS].[SStaff_SStaff].[TemporaryStateName] AS [SStaff_SStaff_TemporaryStateName]
		,[CRS].[SStaff_SStaff].[TemporaryZipCode] AS [SStaff_SStaff_TemporaryZipCode]
		,[CRS].[SStaff_SStaff].[TerminationDate] AS [SStaff_SStaff_TerminationDate]
		,[CRS].[SStaff_SStaff].[TerminationReason] AS [SStaff_SStaff_TerminationReason]
		,[CRS].[SStaff_SStaff].[VANumber] AS [SStaff_SStaff_VANumber]
		,[CRS].[SStaff_SStaff].[VerifyCodeLastChangedDate] AS [SStaff_SStaff_VerifyCodeLastChangedDate]
		,[CRS].[SStaff_SStaff].[VistaCreateDate] AS [SStaff_SStaff_VistaCreateDate]
		,[CRS].[SStaff_SStaff].[VistaEditDate] AS [SStaff_SStaff_VistaEditDate]
		,[CRS].[SStaff_SStaff].[VoicePager] AS [SStaff_SStaff_VoicePager]
		,[CRS].[SStaff_SStaff].[ZipCode] AS [SStaff_SStaff_ZipCode]
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[STD_REFERRALSTS] ON [CRS].[STD_REFERRALSTS].[ID] = [CRS].[REFERRAL].[STD_REFERRALSTS_ID]
			LEFT OUTER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			LEFT OUTER JOIN [CRS].[SStaff_SStaff] ON [CRS].[SStaff_SStaff].[Provider_ID] = [CRS].[REFERRAL].[Provider_ID]
	WHERE 
		[CRS].[REFERRAL].[STD_REGISTRY_ID] = @CURRENT_REGISTRY_ID 
		AND (@STD_REFERRALSTS_ID = 0 OR [CRS].[REFERRAL].[STD_REFERRALSTS_ID] = @STD_REFERRALSTS_ID);
END

GO
-- =============================================
-- Author:        
-- Create date:   12/28/2015
-- Description:   Get all records by Registry and Status
-- 6/29/2016 commented out the left join with spatient and patient by patient_id and added it with patienticn instead.
---               Updated Stored Procedure to Display either Zip or PostalCode from SPATIENT table.
-- =============================================
ALTER PROCEDURE [CRS].[usp_REFERRAL_getitemsByRegistryStatus_optimized] (@CURRENT_USER VARCHAR(30), @CURRENT_REGISTRY_ID INT, @STD_REFERRALSTS_ID INT)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_REFERRAL_getitemsByRegistryStatus', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT 
		[CRS].[REFERRAL].[REFERRAL_ID] AS [REFERRAL_REFERRAL_ID]
		,[CRS].[REFERRAL].[REFERRAL_CLASS_TEXT] AS [REFERRAL_REFERRAL_CLASS_TEXT]
		,[CRS].[REFERRAL].[REFERRAL_DATE] AS [REFERRAL_REFERRAL_DATE]
		,RIGHT(ISNULL([CRS].[SPATIENT].[PatientSSN], '0000'), 4) AS [SPATIENT_PatientLastFour]
		,[CRS].[SPATIENT].[PatientLastName] AS [SPATIENT_PatientLastName]
		,[CRS].[SPATIENT].[PatientFirstName] AS [SPATIENT_PatientFirstName]
		,[CRS].[SPATIENT].[DateOfBirth] AS [SPATIENT_DateOfBirth]
		,[CRS].[SPATIENT].[Gender] AS [SPATIENT_Gender]
		,[CRS].[SPATIENT].[City] AS [SPATIENT_City]
		,[CRS].[SPATIENT].[State] AS [SPATIENT_State]
		,ISNULL([CRS].[SPATIENT].[PostalCode],[CRS].[SPATIENT].[Zip])  AS [SPATIENT_PostalCode]

		--,[CRS].[PATIENT].[LAST_NAME] AS [PATIENT_LAST_NAME]
		--,[CRS].[REFERRAL].[COMMENT_TEXT] AS [REFERRAL_COMMENT_TEXT]
		--,[CRS].[REFERRAL].[CREATED] AS [REFERRAL_CREATED]
		--,[CRS].[REFERRAL].[CREATEDBY] AS [REFERRAL_CREATEDBY]
		--,[CRS].[REFERRAL].[CREATEDSOURCE] AS [REFERRAL_CREATEDSOURCE]
		--,[CRS].[REFERRAL].[DUPLICATE_FLAG] AS [REFERRAL_DUPLICATE_FLAG]
		--,[CRS].[REFERRAL].[PATIENT_ID] AS [REFERRAL_PATIENT_ID]
		--,[CRS].[REFERRAL].[PROVIDER_ID] AS [REFERRAL_PROVIDER_ID]
		--
		
		
		--,[CRS].[REFERRAL].[REVIEW_BY] AS [REFERRAL_REVIEW_BY]
		--,[CRS].[REFERRAL].[REVIEW_DATE] AS [REFERRAL_REVIEW_DATE]
		--,[CRS].[REFERRAL].[STD_REFERRALSTS_ID] AS [REFERRAL_STD_REFERRALSTS_ID]
		--,[CRS].[REFERRAL].[STD_REGISTRY_ID] AS [REFERRAL_STD_REGISTRY_ID]
		--,[CRS].[REFERRAL].[STD_REMINDERCLASS_ID] AS [REFERRAL_STD_REMINDERCLASS_ID]
		--,[CRS].[REFERRAL].[UPDATED] AS [REFERRAL_UPDATED]
		--,[CRS].[REFERRAL].[UPDATEDBY] AS [REFERRAL_UPDATEDBY]
		--,[CRS].[REFERRAL].[UPDATEDSOURCE] AS [REFERRAL_UPDATEDSOURCE]

		--,[CRS].[STD_REGISTRY].[CODE] AS [STD_REGISTRY_CODE]
		--,[CRS].[STD_REGISTRY].[COMMENTS] AS [STD_REGISTRY_COMMENTS]
		--,[CRS].[STD_REGISTRY].[CREATED] AS [STD_REGISTRY_CREATED]
		--,[CRS].[STD_REGISTRY].[CREATEDBY] AS [STD_REGISTRY_CREATEDBY]
		--,[CRS].[STD_REGISTRY].[DESCRIPTION_TEXT] AS [STD_REGISTRY_DESCRIPTION_TEXT]
		--,[CRS].[STD_REGISTRY].[ID] AS [STD_REGISTRY_ID]
		--,[CRS].[STD_REGISTRY].[INACTIVE_DATE] AS [STD_REGISTRY_INACTIVE_DATE]
		--,[CRS].[STD_REGISTRY].[INACTIVE_FLAG] AS [STD_REGISTRY_INACTIVE_FLAG]
		--,[CRS].[STD_REGISTRY].[NAME] AS [STD_REGISTRY_NAME]
		--,[CRS].[STD_REGISTRY].[REGISTRY_ADMINISTRATOR] AS [STD_REGISTRY_REGISTRY_ADMINISTRATOR]
		--,[CRS].[STD_REGISTRY].[REGISTRY_OWNER] AS [STD_REGISTRY_REGISTRY_OWNER]
		--,[CRS].[STD_REGISTRY].[REGISTRY_SUPPORT_CONTACT] AS [STD_REGISTRY_REGISTRY_SUPPORT_CONTACT]
		--,[CRS].[STD_REGISTRY].[SORT_ORDER] AS [STD_REGISTRY_SORT_ORDER]
		--,[CRS].[STD_REGISTRY].[UPDATED] AS [STD_REGISTRY_UPDATED]
		--,[CRS].[STD_REGISTRY].[UPDATEDBY] AS [STD_REGISTRY_UPDATEDBY]

		--,[CRS].[PATIENT].[BIRTH_DATE] AS [PATIENT_BIRTH_DATE]
		--,[CRS].[PATIENT].[CELL_PHONE] AS [PATIENT_CELL_PHONE]
		--,[CRS].[PATIENT].[CREATED] AS [PATIENT_CREATED]
		--,[CRS].[PATIENT].[CREATEDBY] AS [PATIENT_CREATEDBY]
		--,[CRS].[PATIENT].[DEATH_DATE] AS [PATIENT_DEATH_DATE]
		--,[CRS].[PATIENT].[EMAIL_ADDRESS] AS [PATIENT_EMAIL_ADDRESS]
		--,[CRS].[PATIENT].[FIRST_NAME] AS [PATIENT_FIRST_NAME]
		
		--,[CRS].[PATIENT].[MIDDLE_NAME] AS [PATIENT_MIDDLE_NAME]
		--,[CRS].[PATIENT].[OEFOIF_IND] AS [PATIENT_OEFOIF_IND]
		--,[CRS].[PATIENT].[PATIENT_ID] AS [PATIENT_PATIENT_ID]
		--,[CRS].[PATIENT].[PATIENTSID] AS [PATIENT_PATIENTSID]
		--,[CRS].[PATIENT].[PERFERRED_ADDRESS_TYPE] AS [PATIENT_PERFERRED_ADDRESS_TYPE]
		--,[CRS].[PATIENT].[UPDATED] AS [PATIENT_UPDATED]
		--,[CRS].[PATIENT].[UPDATEDBY] AS [PATIENT_UPDATEDBY]

		--,[CRS].[STD_REFERRALSTS].[CODE] AS [STD_REFERRALSTS_CODE]
		--,[CRS].[STD_REFERRALSTS].[CREATED] AS [STD_REFERRALSTS_CREATED]
		--,[CRS].[STD_REFERRALSTS].[CREATEDBY] AS [STD_REFERRALSTS_CREATEDBY]
		--,[CRS].[STD_REFERRALSTS].[DESCRIPTION_TEXT] AS [STD_REFERRALSTS_DESCRIPTION_TEXT]
		--,[CRS].[STD_REFERRALSTS].[ID] AS [STD_REFERRALSTS_ID]
		--,[CRS].[STD_REFERRALSTS].[INACTIVE_DATE] AS [STD_REFERRALSTS_INACTIVE_DATE]
		--,[CRS].[STD_REFERRALSTS].[INACTIVE_FLAG] AS [STD_REFERRALSTS_INACTIVE_FLAG]
		--,[CRS].[STD_REFERRALSTS].[NAME] AS [STD_REFERRALSTS_NAME]
		--,[CRS].[STD_REFERRALSTS].[SORT_ORDER] AS [STD_REFERRALSTS_SORT_ORDER]
		--,[CRS].[STD_REFERRALSTS].[STD_REGISTRY_ID] AS [STD_REFERRALSTS_STD_REGISTRY_ID]
		--,[CRS].[STD_REFERRALSTS].[UPDATED] AS [STD_REFERRALSTS_UPDATED]
		--,[CRS].[STD_REFERRALSTS].[UPDATEDBY] AS [STD_REFERRALSTS_UPDATEDBY]

		--,[CRS].[SPATIENT].[AddressChangeInstitutionIEN] AS [SPATIENT_AddressChangeInstitutionIEN]
		--,[CRS].[SPATIENT].[AddressChangeInstitutionSID] AS [SPATIENT_AddressChangeInstitutionSID]
		--,[CRS].[SPATIENT].[AddressChangeStaffIEN] AS [SPATIENT_AddressChangeStaffIEN]
		--,[CRS].[SPATIENT].[AddressChangeStaffSID] AS [SPATIENT_AddressChangeStaffSID]
		--,[CRS].[SPATIENT].[Age] AS [SPATIENT_Age]
		--,[CRS].[SPATIENT].[BadAddressIndicator] AS [SPATIENT_BadAddressIndicator]
		--,[CRS].[SPATIENT].[CDDeterminingInstitutionIEN] AS [SPATIENT_CDDeterminingInstitutionIEN]
		--,[CRS].[SPATIENT].[City] AS [SPATIENT_City]
		--,[CRS].[SPATIENT].[CombatFromVistaDate] AS [SPATIENT_CombatFromVistaDate]
		--,[CRS].[SPATIENT].[CombatToVistaDate] AS [SPATIENT_CombatToVistaDate]
		--,[CRS].[SPATIENT].[ConfidentialAddressActiveFlag] AS [SPATIENT_ConfidentialAddressActiveFlag]
		--,[CRS].[SPATIENT].[Country] AS [SPATIENT_Country]
		--,[CRS].[SPATIENT].[CountryIEN] AS [SPATIENT_CountryIEN]
		--,[CRS].[SPATIENT].[CountrySID] AS [SPATIENT_CountrySID]
		--,[CRS].[SPATIENT].[County] AS [SPATIENT_County]
		--,[CRS].[SPATIENT].[Created] AS [SPATIENT_Created]
		--,[CRS].[SPATIENT].[CreatedBy] AS [SPATIENT_CreatedBy]
		--,[CRS].[SPATIENT].[CurrentMeansTestStatusIEN] AS [SPATIENT_CurrentMeansTestStatusIEN]
		--,[CRS].[SPATIENT].[DateOfBirth] AS [SPATIENT_DateOfBirth]
		--,[CRS].[SPATIENT].[DateOfBirthText] AS [SPATIENT_DateOfBirthText]
		--,[CRS].[SPATIENT].[DateOfDeath] AS [SPATIENT_DateOfDeath]
		--,[CRS].[SPATIENT].[DateOfDeathText] AS [SPATIENT_DateOfDeathText]
		--,[CRS].[SPATIENT].[Deceased] AS [SPATIENT_Deceased]
		--,[CRS].[SPATIENT].[DEFAULT_RECORD] AS [SPATIENT_DEFAULT_RECORD]
		--,[CRS].[SPATIENT].[Eligibility] AS [SPATIENT_Eligibility]
		--,[CRS].[SPATIENT].[EligibilityIEN] AS [SPATIENT_EligibilityIEN]
		--,[CRS].[SPATIENT].[EligibilitySID] AS [SPATIENT_EligibilitySID]
		--,[CRS].[SPATIENT].[EligibilityStatus] AS [SPATIENT_EligibilityStatus]
		--,[CRS].[SPATIENT].[EligibilityVACode] AS [SPATIENT_EligibilityVACode]
		--,[CRS].[SPATIENT].[EligibilityVerificationSource] AS [SPATIENT_EligibilityVerificationSource]
		--,[CRS].[SPATIENT].[EmailAddress] AS [SPATIENT_EmailAddress]
		--,[CRS].[SPATIENT].[EnteredIntoFileDate] AS [SPATIENT_EnteredIntoFileDate]
		--,[CRS].[SPATIENT].[EnteredIntoFileDateTransformSID] AS [SPATIENT_EnteredIntoFileDateTransformSID]
		--,[CRS].[SPATIENT].[EnteredIntoFileVistaErrorDate] AS [SPATIENT_EnteredIntoFileVistaErrorDate]
		--,[CRS].[SPATIENT].[ETLBatchID] AS [SPATIENT_ETLBatchID]
		--,[CRS].[SPATIENT].[ExcludeFromFacilityDirectoryFlag] AS [SPATIENT_ExcludeFromFacilityDirectoryFlag]
		--,[CRS].[SPATIENT].[Gender] AS [SPATIENT_Gender]
		--,[CRS].[SPATIENT].[GISAddressType] AS [SPATIENT_GISAddressType]
		--,[CRS].[SPATIENT].[GISAddressUpdatedDate] AS [SPATIENT_GISAddressUpdatedDate]
		--,[CRS].[SPATIENT].[GISCongressDistrict] AS [SPATIENT_GISCongressDistrict]
		--,[CRS].[SPATIENT].[GISFIPSCode] AS [SPATIENT_GISFIPSCode]
		--,[CRS].[SPATIENT].[GISLocatorName] AS [SPATIENT_GISLocatorName]
		--,[CRS].[SPATIENT].[GISMarket] AS [SPATIENT_GISMarket]
		--,[CRS].[SPATIENT].[GISMatchedAddress] AS [SPATIENT_GISMatchedAddress]
		--,[CRS].[SPATIENT].[GISMatchMethodCode] AS [SPATIENT_GISMatchMethodCode]
		--,[CRS].[SPATIENT].[GISMatchScore] AS [SPATIENT_GISMatchScore]
		--,[CRS].[SPATIENT].[GISMatchStatusCode] AS [SPATIENT_GISMatchStatusCode]
		--,[CRS].[SPATIENT].[GISPatientAddressLatitude] AS [SPATIENT_GISPatientAddressLatitude]
		--,[CRS].[SPATIENT].[GISPatientAddressLongitude] AS [SPATIENT_GISPatientAddressLongitude]
		--,[CRS].[SPATIENT].[GISSector] AS [SPATIENT_GISSector]
		--,[CRS].[SPATIENT].[GISStreetSide] AS [SPATIENT_GISStreetSide]
		--,[CRS].[SPATIENT].[GISSubmarket] AS [SPATIENT_GISSubmarket]
		--,[CRS].[SPATIENT].[GISURH] AS [SPATIENT_GISURH]
		--,[CRS].[SPATIENT].[InsuranceCoverageFlag] AS [SPATIENT_InsuranceCoverageFlag]
		--,[CRS].[SPATIENT].[LastServiceEntryDate] AS [SPATIENT_LastServiceEntryDate]
		--,[CRS].[SPATIENT].[LastServiceEntryDateTransformSID] AS [SPATIENT_LastServiceEntryDateTransformSID]
		--,[CRS].[SPATIENT].[LastServiceEntryVistaErrorDate] AS [SPATIENT_LastServiceEntryVistaErrorDate]
		--,[CRS].[SPATIENT].[LastServiceSeparationDate] AS [SPATIENT_LastServiceSeparationDate]
		--,[CRS].[SPATIENT].[LastServiceSeparationDateTransformSID] AS [SPATIENT_LastServiceSeparationDateTransformSID]
		--,[CRS].[SPATIENT].[LastServiceSeparationVistaErrorDate] AS [SPATIENT_LastServiceSeparationVistaErrorDate]
		--,[CRS].[SPATIENT].[MaritalStatus] AS [SPATIENT_MaritalStatus]
		--,[CRS].[SPATIENT].[MaritalStatusIEN] AS [SPATIENT_MaritalStatusIEN]
		--,[CRS].[SPATIENT].[MaritalStatusSID] AS [SPATIENT_MaritalStatusSID]
		--,[CRS].[SPATIENT].[MedicaidNumber] AS [SPATIENT_MedicaidNumber]
		--,[CRS].[SPATIENT].[MothersMaidenName] AS [SPATIENT_MothersMaidenName]
		--,[CRS].[SPATIENT].[OEF_OIF_IND] AS [SPATIENT_OEF_OIF_IND]
		--,[CRS].[SPATIENT].[OpCode] AS [SPATIENT_OpCode]
		--,[CRS].[SPATIENT].[Patient_ID] AS [SPATIENT_Patient_ID]
		--,[CRS].[SPATIENT].[PatientFirstName] AS [SPATIENT_PatientFirstName]
		--,[CRS].[SPATIENT].[PatientICN] AS [SPATIENT_PatientICN]
		--,[CRS].[SPATIENT].[PatientICNChecksum] AS [SPATIENT_PatientICNChecksum]
		--,[CRS].[SPATIENT].[PatientIEN] AS [SPATIENT_PatientIEN]
		--,[CRS].[SPATIENT].[PatientLastName] AS [SPATIENT_PatientLastName]
		--,[CRS].[SPATIENT].[PatientName] AS [SPATIENT_PatientName]
		--,[CRS].[SPATIENT].[PatientSID] AS [SPATIENT_PatientSID]
		--,[CRS].[SPATIENT].[PatientSSN] AS [SPATIENT_PatientSSN]
		--,[CRS].[SPATIENT].[PercentServiceConnect] AS [SPATIENT_PercentServiceConnect]
		--,[CRS].[SPATIENT].[PeriodOfService] AS [SPATIENT_PeriodOfService]
		--,[CRS].[SPATIENT].[PeriodOfServiceIEN] AS [SPATIENT_PeriodOfServiceIEN]
		--,[CRS].[SPATIENT].[PeriodOfServiceSID] AS [SPATIENT_PeriodOfServiceSID]
		--,[CRS].[SPATIENT].[PhoneCellular] AS [SPATIENT_PhoneCellular]
		--,[CRS].[SPATIENT].[PhoneResidence] AS [SPATIENT_PhoneResidence]
		--,[CRS].[SPATIENT].[PhoneWork] AS [SPATIENT_PhoneWork]
		--,[CRS].[SPATIENT].[PostalCode] AS [SPATIENT_PostalCode]
		--,[CRS].[SPATIENT].[POWLocationIEN] AS [SPATIENT_POWLocationIEN]
		--,[CRS].[SPATIENT].[PreferredInstitutionIEN] AS [SPATIENT_PreferredInstitutionIEN]
		--,[CRS].[SPATIENT].[Province] AS [SPATIENT_Province]
		--,[CRS].[SPATIENT].[PseudoSSNFlag] AS [SPATIENT_PseudoSSNFlag]
		--,[CRS].[SPATIENT].[PurpleHeartInstitutionIEN] AS [SPATIENT_PurpleHeartInstitutionIEN]
		--,[CRS].[SPATIENT].[RaceIEN] AS [SPATIENT_RaceIEN]
		--,[CRS].[SPATIENT].[RaceSID] AS [SPATIENT_RaceSID]
		--,[CRS].[SPATIENT].[Religion] AS [SPATIENT_Religion]
		--,[CRS].[SPATIENT].[ReligionIEN] AS [SPATIENT_ReligionIEN]
		--,[CRS].[SPATIENT].[ReligionSID] AS [SPATIENT_ReligionSID]
		--,[CRS].[SPATIENT].[RoomBedIEN] AS [SPATIENT_RoomBedIEN]
		--,[CRS].[SPATIENT].[ScrSSN] AS [SPATIENT_ScrSSN]
		--,[CRS].[SPATIENT].[SensitiveFlag] AS [SPATIENT_SensitiveFlag]
		--,[CRS].[SPATIENT].[Sta3n] AS [SPATIENT_Sta3n]
		--,[CRS].[SPATIENT].[State] AS [SPATIENT_State]
		--,[CRS].[SPATIENT].[StateIEN] AS [SPATIENT_StateIEN]
		--,[CRS].[SPATIENT].[StateSID] AS [SPATIENT_StateSID]
		--,[CRS].[SPATIENT].[STD_COMBATLOCATION_ID] AS [SPATIENT_STD_COMBATLOCATION_ID]
		--,[CRS].[SPATIENT].[STD_ENTHNICITY_ID] AS [SPATIENT_STD_ENTHNICITY_ID]
		--,[CRS].[SPATIENT].[STD_GENDER_ID] AS [SPATIENT_STD_GENDER_ID]
		--,[CRS].[SPATIENT].[STD_MARITALSTATUS_ID] AS [SPATIENT_STD_MARITALSTATUS_ID]
		--,[CRS].[SPATIENT].[STD_RACE_ID] AS [SPATIENT_STD_RACE_ID]
		--,[CRS].[SPATIENT].[STD_SERVICEBRANCH_ID] AS [SPATIENT_STD_SERVICEBRANCH_ID]
		--,[CRS].[SPATIENT].[StdRegistryId] AS [SPATIENT_StdRegistryId]
		--,[CRS].[SPATIENT].[StreetAddress1] AS [SPATIENT_StreetAddress1]
		--,[CRS].[SPATIENT].[StreetAddress2] AS [SPATIENT_StreetAddress2]
		--,[CRS].[SPATIENT].[StreetAddress3] AS [SPATIENT_StreetAddress3]
		--,[CRS].[SPATIENT].[TemporaryAddressChangeInstitutionIEN] AS [SPATIENT_TemporaryAddressChangeInstitutionIEN]
		--,[CRS].[SPATIENT].[Updatedate] AS [SPATIENT_Updatedate]
		--,[CRS].[SPATIENT].[UpdatedBy] AS [SPATIENT_UpdatedBy]
		--,[CRS].[SPATIENT].[VeteranFlag] AS [SPATIENT_VeteranFlag]
		--,[CRS].[SPATIENT].[VistaCreateDate] AS [SPATIENT_VistaCreateDate]
		--,[CRS].[SPATIENT].[VistaEditDate] AS [SPATIENT_VistaEditDate]
		--,[CRS].[SPATIENT].[Zip] AS [SPATIENT_Zip]
		--,[CRS].[SPATIENT].[Zip4] AS [SPATIENT_Zip4]
		

		--,[CRS].[SStaff_SStaff].[City] AS [SStaff_SStaff_City]
		--,[CRS].[SStaff_SStaff].[CommercialPhone] AS [SStaff_SStaff_CommercialPhone]
		--,[CRS].[SStaff_SStaff].[CreatedByStaffSID] AS [SStaff_SStaff_CreatedByStaffSID]
		--,[CRS].[SStaff_SStaff].[DEA] AS [SStaff_SStaff_DEA]
		--,[CRS].[SStaff_SStaff].[Degree] AS [SStaff_SStaff_Degree]
		--,[CRS].[SStaff_SStaff].[DelegateOfStaffIEN] AS [SStaff_SStaff_DelegateOfStaffIEN]
		--,[CRS].[SStaff_SStaff].[DelegateOfStaffSID] AS [SStaff_SStaff_DelegateOfStaffSID]
		--,[CRS].[SStaff_SStaff].[DelegationDate] AS [SStaff_SStaff_DelegationDate]
		--,[CRS].[SStaff_SStaff].[DelegationLevel] AS [SStaff_SStaff_DelegationLevel]
		--,[CRS].[SStaff_SStaff].[DigitalPager] AS [SStaff_SStaff_DigitalPager]
		--,[CRS].[SStaff_SStaff].[ElectronicSignatureCodeFlag] AS [SStaff_SStaff_ElectronicSignatureCodeFlag]
		--,[CRS].[SStaff_SStaff].[EmailAddress] AS [SStaff_SStaff_EmailAddress]
		--,[CRS].[SStaff_SStaff].[EnteredDate] AS [SStaff_SStaff_EnteredDate]
		--,[CRS].[SStaff_SStaff].[ETLBatchID] AS [SStaff_SStaff_ETLBatchID]
		--,[CRS].[SStaff_SStaff].[FaxNumber] AS [SStaff_SStaff_FaxNumber]
		--,[CRS].[SStaff_SStaff].[FirstName] AS [SStaff_SStaff_FirstName]
		--,[CRS].[SStaff_SStaff].[Gender] AS [SStaff_SStaff_Gender]
		--,[CRS].[SStaff_SStaff].[HINQEmployeeNumberFlag] AS [SStaff_SStaff_HINQEmployeeNumberFlag]
		--,[CRS].[SStaff_SStaff].[HomePhone] AS [SStaff_SStaff_HomePhone]
		--,[CRS].[SStaff_SStaff].[InactivationDate] AS [SStaff_SStaff_InactivationDate]
		--,[CRS].[SStaff_SStaff].[LastEditedDateTime] AS [SStaff_SStaff_LastEditedDateTime]
		--,[CRS].[SStaff_SStaff].[LastName] AS [SStaff_SStaff_LastName]
		--,[CRS].[SStaff_SStaff].[LastSignonDateTime] AS [SStaff_SStaff_LastSignonDateTime]
		--,[CRS].[SStaff_SStaff].[LastUsedTerminalType] AS [SStaff_SStaff_LastUsedTerminalType]
		--,[CRS].[SStaff_SStaff].[MailCode] AS [SStaff_SStaff_MailCode]
		--,[CRS].[SStaff_SStaff].[MiddleName] AS [SStaff_SStaff_MiddleName]
		--,[CRS].[SStaff_SStaff].[NetworkUsername] AS [SStaff_SStaff_NetworkUsername]
		--,[CRS].[SStaff_SStaff].[NPI] AS [SStaff_SStaff_NPI]
		--,[CRS].[SStaff_SStaff].[NPIAuthorizedReleaseFlag] AS [SStaff_SStaff_NPIAuthorizedReleaseFlag]
		--,[CRS].[SStaff_SStaff].[OfficePhone] AS [SStaff_SStaff_OfficePhone]
		--,[CRS].[SStaff_SStaff].[OpCode] AS [SStaff_SStaff_OpCode]
		--,[CRS].[SStaff_SStaff].[PACFlag] AS [SStaff_SStaff_PACFlag]
		--,[CRS].[SStaff_SStaff].[Phone3] AS [SStaff_SStaff_Phone3]
		--,[CRS].[SStaff_SStaff].[Phone4] AS [SStaff_SStaff_Phone4]
		--,[CRS].[SStaff_SStaff].[PositionTitle] AS [SStaff_SStaff_PositionTitle]
		--,[CRS].[SStaff_SStaff].[Provider_ID] AS [SStaff_SStaff_Provider_ID]
		--,[CRS].[SStaff_SStaff].[ProviderClass] AS [SStaff_SStaff_ProviderClass]
		--,[CRS].[SStaff_SStaff].[ProviderClassSID] AS [SStaff_SStaff_ProviderClassSID]
		--,[CRS].[SStaff_SStaff].[ProviderScheduleType] AS [SStaff_SStaff_ProviderScheduleType]
		--,[CRS].[SStaff_SStaff].[Room] AS [SStaff_SStaff_Room]
		--,[CRS].[SStaff_SStaff].[ServiceComputationDate] AS [SStaff_SStaff_ServiceComputationDate]
		--,[CRS].[SStaff_SStaff].[ServiceSection] AS [SStaff_SStaff_ServiceSection]
		--,[CRS].[SStaff_SStaff].[ServiceSectionSID] AS [SStaff_SStaff_ServiceSectionSID]
		--,[CRS].[SStaff_SStaff].[ServiceType] AS [SStaff_SStaff_ServiceType]
		--,[CRS].[SStaff_SStaff].[SignatureBlockName] AS [SStaff_SStaff_SignatureBlockName]
		--,[CRS].[SStaff_SStaff].[SignatureBlockTitle] AS [SStaff_SStaff_SignatureBlockTitle]
		--,[CRS].[SStaff_SStaff].[SocialWorkerImmediateSupervisorStaffSID] AS [SStaff_SStaff_SocialWorkerImmediateSupervisorStaffSID]
		--,[CRS].[SStaff_SStaff].[SocialWorkerPositionTitle] AS [SStaff_SStaff_SocialWorkerPositionTitle]
		--,[CRS].[SStaff_SStaff].[Sta3n] AS [SStaff_SStaff_Sta3n]
		--,[CRS].[SStaff_SStaff].[StaffIEN] AS [SStaff_SStaff_StaffIEN]
		--,[CRS].[SStaff_SStaff].[StaffName] AS [SStaff_SStaff_StaffName]
		--,[CRS].[SStaff_SStaff].[StaffNamePrefix] AS [SStaff_SStaff_StaffNamePrefix]
		--,[CRS].[SStaff_SStaff].[StaffNameSuffix] AS [SStaff_SStaff_StaffNameSuffix]
		--,[CRS].[SStaff_SStaff].[StaffSID] AS [SStaff_SStaff_StaffSID]
		--,[CRS].[SStaff_SStaff].[StateName] AS [SStaff_SStaff_StateName]
		--,[CRS].[SStaff_SStaff].[StreetAddress1] AS [SStaff_SStaff_StreetAddress1]
		--,[CRS].[SStaff_SStaff].[StreetAddress2] AS [SStaff_SStaff_StreetAddress2]
		--,[CRS].[SStaff_SStaff].[StreetAddress3] AS [SStaff_SStaff_StreetAddress3]
		--,[CRS].[SStaff_SStaff].[SupplyEmployee] AS [SStaff_SStaff_SupplyEmployee]
		--,[CRS].[SStaff_SStaff].[TemporaryAddress1] AS [SStaff_SStaff_TemporaryAddress1]
		--,[CRS].[SStaff_SStaff].[TemporaryAddress2] AS [SStaff_SStaff_TemporaryAddress2]
		--,[CRS].[SStaff_SStaff].[TemporaryAddress3] AS [SStaff_SStaff_TemporaryAddress3]
		--,[CRS].[SStaff_SStaff].[TemporaryAddressEndDate] AS [SStaff_SStaff_TemporaryAddressEndDate]
		--,[CRS].[SStaff_SStaff].[TemporaryAddressStartDate] AS [SStaff_SStaff_TemporaryAddressStartDate]
		--,[CRS].[SStaff_SStaff].[TemporaryCity] AS [SStaff_SStaff_TemporaryCity]
		--,[CRS].[SStaff_SStaff].[TemporaryStateName] AS [SStaff_SStaff_TemporaryStateName]
		--,[CRS].[SStaff_SStaff].[TemporaryZipCode] AS [SStaff_SStaff_TemporaryZipCode]
		--,[CRS].[SStaff_SStaff].[TerminationDate] AS [SStaff_SStaff_TerminationDate]
		--,[CRS].[SStaff_SStaff].[TerminationReason] AS [SStaff_SStaff_TerminationReason]
		--,[CRS].[SStaff_SStaff].[VANumber] AS [SStaff_SStaff_VANumber]
		--,[CRS].[SStaff_SStaff].[VerifyCodeLastChangedDate] AS [SStaff_SStaff_VerifyCodeLastChangedDate]
		--,[CRS].[SStaff_SStaff].[VistaCreateDate] AS [SStaff_SStaff_VistaCreateDate]
		--,[CRS].[SStaff_SStaff].[VistaEditDate] AS [SStaff_SStaff_VistaEditDate]
		--,[CRS].[SStaff_SStaff].[VoicePager] AS [SStaff_SStaff_VoicePager]
		--,[CRS].[SStaff_SStaff].[ZipCode] AS [SStaff_SStaff_ZipCode]
	FROM 
		[CRS].[REFERRAL]
			--INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			--INNER JOIN [CRS].[STD_REFERRALSTS] ON [CRS].[STD_REFERRALSTS].[ID] = [CRS].[REFERRAL].[STD_REFERRALSTS_ID]
			--LEFT OUTER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[Patient_ID] = [CRS].[PATIENT].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			--LEFT OUTER JOIN [CRS].[SStaff_SStaff] ON [CRS].[SStaff_SStaff].[Provider_ID] = [CRS].[REFERRAL].[Provider_ID]
	WHERE 
		[CRS].[REFERRAL].[STD_REGISTRY_ID] = @CURRENT_REGISTRY_ID 
		AND (@STD_REFERRALSTS_ID = 0 OR [CRS].[REFERRAL].[STD_REFERRALSTS_ID] = @STD_REFERRALSTS_ID);
END


GO

-- =============================================
-- Author:        
-- Create date:   12/28/2015
-- Description:   Get all records by Registry and Status
-- 6/29/2016 commented out the left join with spatient and patient by patient_id and added it with patienticn instead.
---               Updated Stored Procedure to Display either Zip or PostalCode from SPATIENT table.
-- =============================================
ALTER PROCEDURE [CRS].[usp_REFERRAL_getitemsByRegistryStatus_optimized2] (@CURRENT_USER VARCHAR(30), @CURRENT_REGISTRY_ID INT, @STD_REFERRALSTS_ID INT)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_REFERRAL_getitemsByRegistryStatus', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT 
		a.[REFERRAL_ID] AS [REFERRAL_REFERRAL_ID]
		,a.[REFERRAL_CLASS_TEXT] AS [REFERRAL_REFERRAL_CLASS_TEXT]
		,a.[REFERRAL_DATE] AS [REFERRAL_REFERRAL_DATE]
		,a.[STD_REGISTRY_ID]
		,b.PatientICN
	INTO #referral
	FROM [CRS].[REFERRAL] AS a 
	INNER JOIN crs.PATIENT AS b ON b.PATIENT_ID = a.PATIENT_ID
	WHERE a.[STD_REGISTRY_ID] = @CURRENT_REGISTRY_ID 
	AND (@STD_REFERRALSTS_ID = 0 OR a.[STD_REFERRALSTS_ID] = @STD_REFERRALSTS_ID);

	SELECT
		RIGHT(ISNULL([CRS].[SPATIENT].[PatientSSN], '0000'), 4) AS [SPATIENT_PatientLastFour]
		,[CRS].[SPATIENT].[PatientLastName] AS [SPATIENT_PatientLastName]
		,[CRS].[SPATIENT].[PatientFirstName] AS [SPATIENT_PatientFirstName]
		,[CRS].[SPATIENT].[DateOfBirth] AS [SPATIENT_DateOfBirth]
		,[CRS].[SPATIENT].[Gender] AS [SPATIENT_Gender]
		,[CRS].[SPATIENT].[City] AS [SPATIENT_City]
		,[CRS].[SPATIENT].[State] AS [SPATIENT_State]
		,ISNULL([CRS].[SPATIENT].[PostalCode],[CRS].[SPATIENT].[Zip]) AS [SPATIENT_PostalCode]
		,crs.spatient.[StdRegistryId]
		,crs.SPATIENT.PatientICN
	INTO #spatient
	FROM [CRS].[SPATIENT]
	WHERE
	[CRS].[spatient].[StdRegistryId] = @CURRENT_REGISTRY_ID 

	SELECT 
	a.[REFERRAL_REFERRAL_ID],
	a.[REFERRAL_REFERRAL_CLASS_TEXT],
	a.[REFERRAL_REFERRAL_DATE],
	b.[SPATIENT_PatientLastFour],
	b.[SPATIENT_PatientLastName],
	b.[SPATIENT_PatientFirstName],
	b.[SPATIENT_DateOfBirth],
	b.[SPATIENT_Gender],
	b.[SPATIENT_City],
	b.[SPATIENT_State],
	b.[SPATIENT_PostalCode],
	b.[StdRegistryId]
	FROM #referral AS a
	INNER JOIN #spatient AS b ON b.PatientICN = a.patienticn
		/*
		--,[CRS].[PATIENT].[LAST_NAME] AS [PATIENT_LAST_NAME]
		--,[CRS].[PATIENT].[FIRST_NAME] AS [PATIENT_FIRST_NAME]
		--,[CRS].[PATIENT].[BIRTH_DATE] AS [PATIENT_BIRTH_DATE]


		--,[CRS].[REFERRAL].[COMMENT_TEXT] AS [REFERRAL_COMMENT_TEXT]
		--,[CRS].[REFERRAL].[CREATED] AS [REFERRAL_CREATED]
		--,[CRS].[REFERRAL].[CREATEDBY] AS [REFERRAL_CREATEDBY]
		--,[CRS].[REFERRAL].[CREATEDSOURCE] AS [REFERRAL_CREATEDSOURCE]
		--,[CRS].[REFERRAL].[DUPLICATE_FLAG] AS [REFERRAL_DUPLICATE_FLAG]
		--,[CRS].[REFERRAL].[PATIENT_ID] AS [REFERRAL_PATIENT_ID]
		--,[CRS].[REFERRAL].[PROVIDER_ID] AS [REFERRAL_PROVIDER_ID]
		--
		
		
		--,[CRS].[REFERRAL].[REVIEW_BY] AS [REFERRAL_REVIEW_BY]
		--,[CRS].[REFERRAL].[REVIEW_DATE] AS [REFERRAL_REVIEW_DATE]
		--,[CRS].[REFERRAL].[STD_REFERRALSTS_ID] AS [REFERRAL_STD_REFERRALSTS_ID]
		--,[CRS].[REFERRAL].[STD_REGISTRY_ID] AS [REFERRAL_STD_REGISTRY_ID]
		--,[CRS].[REFERRAL].[STD_REMINDERCLASS_ID] AS [REFERRAL_STD_REMINDERCLASS_ID]
		--,[CRS].[REFERRAL].[UPDATED] AS [REFERRAL_UPDATED]
		--,[CRS].[REFERRAL].[UPDATEDBY] AS [REFERRAL_UPDATEDBY]
		--,[CRS].[REFERRAL].[UPDATEDSOURCE] AS [REFERRAL_UPDATEDSOURCE]

		--,[CRS].[STD_REGISTRY].[CODE] AS [STD_REGISTRY_CODE]
		--,[CRS].[STD_REGISTRY].[COMMENTS] AS [STD_REGISTRY_COMMENTS]
		--,[CRS].[STD_REGISTRY].[CREATED] AS [STD_REGISTRY_CREATED]
		--,[CRS].[STD_REGISTRY].[CREATEDBY] AS [STD_REGISTRY_CREATEDBY]
		--,[CRS].[STD_REGISTRY].[DESCRIPTION_TEXT] AS [STD_REGISTRY_DESCRIPTION_TEXT]
		--,[CRS].[STD_REGISTRY].[ID] AS [STD_REGISTRY_ID]
		--,[CRS].[STD_REGISTRY].[INACTIVE_DATE] AS [STD_REGISTRY_INACTIVE_DATE]
		--,[CRS].[STD_REGISTRY].[INACTIVE_FLAG] AS [STD_REGISTRY_INACTIVE_FLAG]
		--,[CRS].[STD_REGISTRY].[NAME] AS [STD_REGISTRY_NAME]
		--,[CRS].[STD_REGISTRY].[REGISTRY_ADMINISTRATOR] AS [STD_REGISTRY_REGISTRY_ADMINISTRATOR]
		--,[CRS].[STD_REGISTRY].[REGISTRY_OWNER] AS [STD_REGISTRY_REGISTRY_OWNER]
		--,[CRS].[STD_REGISTRY].[REGISTRY_SUPPORT_CONTACT] AS [STD_REGISTRY_REGISTRY_SUPPORT_CONTACT]
		--,[CRS].[STD_REGISTRY].[SORT_ORDER] AS [STD_REGISTRY_SORT_ORDER]
		--,[CRS].[STD_REGISTRY].[UPDATED] AS [STD_REGISTRY_UPDATED]
		--,[CRS].[STD_REGISTRY].[UPDATEDBY] AS [STD_REGISTRY_UPDATEDBY]

		
		--,[CRS].[PATIENT].[CELL_PHONE] AS [PATIENT_CELL_PHONE]
		--,[CRS].[PATIENT].[CREATED] AS [PATIENT_CREATED]
		--,[CRS].[PATIENT].[CREATEDBY] AS [PATIENT_CREATEDBY]
		--,[CRS].[PATIENT].[DEATH_DATE] AS [PATIENT_DEATH_DATE]
		--,[CRS].[PATIENT].[EMAIL_ADDRESS] AS [PATIENT_EMAIL_ADDRESS]
		
		
		--,[CRS].[PATIENT].[MIDDLE_NAME] AS [PATIENT_MIDDLE_NAME]
		--,[CRS].[PATIENT].[OEFOIF_IND] AS [PATIENT_OEFOIF_IND]
		--,[CRS].[PATIENT].[PATIENT_ID] AS [PATIENT_PATIENT_ID]
		--,[CRS].[PATIENT].[PATIENTSID] AS [PATIENT_PATIENTSID]
		--,[CRS].[PATIENT].[PERFERRED_ADDRESS_TYPE] AS [PATIENT_PERFERRED_ADDRESS_TYPE]
		--,[CRS].[PATIENT].[UPDATED] AS [PATIENT_UPDATED]
		--,[CRS].[PATIENT].[UPDATEDBY] AS [PATIENT_UPDATEDBY]

		--,[CRS].[STD_REFERRALSTS].[CODE] AS [STD_REFERRALSTS_CODE]
		--,[CRS].[STD_REFERRALSTS].[CREATED] AS [STD_REFERRALSTS_CREATED]
		--,[CRS].[STD_REFERRALSTS].[CREATEDBY] AS [STD_REFERRALSTS_CREATEDBY]
		--,[CRS].[STD_REFERRALSTS].[DESCRIPTION_TEXT] AS [STD_REFERRALSTS_DESCRIPTION_TEXT]
		--,[CRS].[STD_REFERRALSTS].[ID] AS [STD_REFERRALSTS_ID]
		--,[CRS].[STD_REFERRALSTS].[INACTIVE_DATE] AS [STD_REFERRALSTS_INACTIVE_DATE]
		--,[CRS].[STD_REFERRALSTS].[INACTIVE_FLAG] AS [STD_REFERRALSTS_INACTIVE_FLAG]
		--,[CRS].[STD_REFERRALSTS].[NAME] AS [STD_REFERRALSTS_NAME]
		--,[CRS].[STD_REFERRALSTS].[SORT_ORDER] AS [STD_REFERRALSTS_SORT_ORDER]
		--,[CRS].[STD_REFERRALSTS].[STD_REGISTRY_ID] AS [STD_REFERRALSTS_STD_REGISTRY_ID]
		--,[CRS].[STD_REFERRALSTS].[UPDATED] AS [STD_REFERRALSTS_UPDATED]
		--,[CRS].[STD_REFERRALSTS].[UPDATEDBY] AS [STD_REFERRALSTS_UPDATEDBY]

		--,[CRS].[SPATIENT].[AddressChangeInstitutionIEN] AS [SPATIENT_AddressChangeInstitutionIEN]
		--,[CRS].[SPATIENT].[AddressChangeInstitutionSID] AS [SPATIENT_AddressChangeInstitutionSID]
		--,[CRS].[SPATIENT].[AddressChangeStaffIEN] AS [SPATIENT_AddressChangeStaffIEN]
		--,[CRS].[SPATIENT].[AddressChangeStaffSID] AS [SPATIENT_AddressChangeStaffSID]
		--,[CRS].[SPATIENT].[Age] AS [SPATIENT_Age]
		--,[CRS].[SPATIENT].[BadAddressIndicator] AS [SPATIENT_BadAddressIndicator]
		--,[CRS].[SPATIENT].[CDDeterminingInstitutionIEN] AS [SPATIENT_CDDeterminingInstitutionIEN]
		--,[CRS].[SPATIENT].[City] AS [SPATIENT_City]
		--,[CRS].[SPATIENT].[CombatFromVistaDate] AS [SPATIENT_CombatFromVistaDate]
		--,[CRS].[SPATIENT].[CombatToVistaDate] AS [SPATIENT_CombatToVistaDate]
		--,[CRS].[SPATIENT].[ConfidentialAddressActiveFlag] AS [SPATIENT_ConfidentialAddressActiveFlag]
		--,[CRS].[SPATIENT].[Country] AS [SPATIENT_Country]
		--,[CRS].[SPATIENT].[CountryIEN] AS [SPATIENT_CountryIEN]
		--,[CRS].[SPATIENT].[CountrySID] AS [SPATIENT_CountrySID]
		--,[CRS].[SPATIENT].[County] AS [SPATIENT_County]
		--,[CRS].[SPATIENT].[Created] AS [SPATIENT_Created]
		--,[CRS].[SPATIENT].[CreatedBy] AS [SPATIENT_CreatedBy]
		--,[CRS].[SPATIENT].[CurrentMeansTestStatusIEN] AS [SPATIENT_CurrentMeansTestStatusIEN]
		--,[CRS].[SPATIENT].[DateOfBirth] AS [SPATIENT_DateOfBirth]
		--,[CRS].[SPATIENT].[DateOfBirthText] AS [SPATIENT_DateOfBirthText]
		--,[CRS].[SPATIENT].[DateOfDeath] AS [SPATIENT_DateOfDeath]
		--,[CRS].[SPATIENT].[DateOfDeathText] AS [SPATIENT_DateOfDeathText]
		--,[CRS].[SPATIENT].[Deceased] AS [SPATIENT_Deceased]
		--,[CRS].[SPATIENT].[DEFAULT_RECORD] AS [SPATIENT_DEFAULT_RECORD]
		--,[CRS].[SPATIENT].[Eligibility] AS [SPATIENT_Eligibility]
		--,[CRS].[SPATIENT].[EligibilityIEN] AS [SPATIENT_EligibilityIEN]
		--,[CRS].[SPATIENT].[EligibilitySID] AS [SPATIENT_EligibilitySID]
		--,[CRS].[SPATIENT].[EligibilityStatus] AS [SPATIENT_EligibilityStatus]
		--,[CRS].[SPATIENT].[EligibilityVACode] AS [SPATIENT_EligibilityVACode]
		--,[CRS].[SPATIENT].[EligibilityVerificationSource] AS [SPATIENT_EligibilityVerificationSource]
		--,[CRS].[SPATIENT].[EmailAddress] AS [SPATIENT_EmailAddress]
		--,[CRS].[SPATIENT].[EnteredIntoFileDate] AS [SPATIENT_EnteredIntoFileDate]
		--,[CRS].[SPATIENT].[EnteredIntoFileDateTransformSID] AS [SPATIENT_EnteredIntoFileDateTransformSID]
		--,[CRS].[SPATIENT].[EnteredIntoFileVistaErrorDate] AS [SPATIENT_EnteredIntoFileVistaErrorDate]
		--,[CRS].[SPATIENT].[ETLBatchID] AS [SPATIENT_ETLBatchID]
		--,[CRS].[SPATIENT].[ExcludeFromFacilityDirectoryFlag] AS [SPATIENT_ExcludeFromFacilityDirectoryFlag]
		--,[CRS].[SPATIENT].[Gender] AS [SPATIENT_Gender]
		--,[CRS].[SPATIENT].[GISAddressType] AS [SPATIENT_GISAddressType]
		--,[CRS].[SPATIENT].[GISAddressUpdatedDate] AS [SPATIENT_GISAddressUpdatedDate]
		--,[CRS].[SPATIENT].[GISCongressDistrict] AS [SPATIENT_GISCongressDistrict]
		--,[CRS].[SPATIENT].[GISFIPSCode] AS [SPATIENT_GISFIPSCode]
		--,[CRS].[SPATIENT].[GISLocatorName] AS [SPATIENT_GISLocatorName]
		--,[CRS].[SPATIENT].[GISMarket] AS [SPATIENT_GISMarket]
		--,[CRS].[SPATIENT].[GISMatchedAddress] AS [SPATIENT_GISMatchedAddress]
		--,[CRS].[SPATIENT].[GISMatchMethodCode] AS [SPATIENT_GISMatchMethodCode]
		--,[CRS].[SPATIENT].[GISMatchScore] AS [SPATIENT_GISMatchScore]
		--,[CRS].[SPATIENT].[GISMatchStatusCode] AS [SPATIENT_GISMatchStatusCode]
		--,[CRS].[SPATIENT].[GISPatientAddressLatitude] AS [SPATIENT_GISPatientAddressLatitude]
		--,[CRS].[SPATIENT].[GISPatientAddressLongitude] AS [SPATIENT_GISPatientAddressLongitude]
		--,[CRS].[SPATIENT].[GISSector] AS [SPATIENT_GISSector]
		--,[CRS].[SPATIENT].[GISStreetSide] AS [SPATIENT_GISStreetSide]
		--,[CRS].[SPATIENT].[GISSubmarket] AS [SPATIENT_GISSubmarket]
		--,[CRS].[SPATIENT].[GISURH] AS [SPATIENT_GISURH]
		--,[CRS].[SPATIENT].[InsuranceCoverageFlag] AS [SPATIENT_InsuranceCoverageFlag]
		--,[CRS].[SPATIENT].[LastServiceEntryDate] AS [SPATIENT_LastServiceEntryDate]
		--,[CRS].[SPATIENT].[LastServiceEntryDateTransformSID] AS [SPATIENT_LastServiceEntryDateTransformSID]
		--,[CRS].[SPATIENT].[LastServiceEntryVistaErrorDate] AS [SPATIENT_LastServiceEntryVistaErrorDate]
		--,[CRS].[SPATIENT].[LastServiceSeparationDate] AS [SPATIENT_LastServiceSeparationDate]
		--,[CRS].[SPATIENT].[LastServiceSeparationDateTransformSID] AS [SPATIENT_LastServiceSeparationDateTransformSID]
		--,[CRS].[SPATIENT].[LastServiceSeparationVistaErrorDate] AS [SPATIENT_LastServiceSeparationVistaErrorDate]
		--,[CRS].[SPATIENT].[MaritalStatus] AS [SPATIENT_MaritalStatus]
		--,[CRS].[SPATIENT].[MaritalStatusIEN] AS [SPATIENT_MaritalStatusIEN]
		--,[CRS].[SPATIENT].[MaritalStatusSID] AS [SPATIENT_MaritalStatusSID]
		--,[CRS].[SPATIENT].[MedicaidNumber] AS [SPATIENT_MedicaidNumber]
		--,[CRS].[SPATIENT].[MothersMaidenName] AS [SPATIENT_MothersMaidenName]
		--,[CRS].[SPATIENT].[OEF_OIF_IND] AS [SPATIENT_OEF_OIF_IND]
		--,[CRS].[SPATIENT].[OpCode] AS [SPATIENT_OpCode]
		--,[CRS].[SPATIENT].[Patient_ID] AS [SPATIENT_Patient_ID]
		--,[CRS].[SPATIENT].[PatientFirstName] AS [SPATIENT_PatientFirstName]
		--,[CRS].[SPATIENT].[PatientICN] AS [SPATIENT_PatientICN]
		--,[CRS].[SPATIENT].[PatientICNChecksum] AS [SPATIENT_PatientICNChecksum]
		--,[CRS].[SPATIENT].[PatientIEN] AS [SPATIENT_PatientIEN]
		--,[CRS].[SPATIENT].[PatientLastName] AS [SPATIENT_PatientLastName]
		--,[CRS].[SPATIENT].[PatientName] AS [SPATIENT_PatientName]
		--,[CRS].[SPATIENT].[PatientSID] AS [SPATIENT_PatientSID]
		--,[CRS].[SPATIENT].[PatientSSN] AS [SPATIENT_PatientSSN]
		--,[CRS].[SPATIENT].[PercentServiceConnect] AS [SPATIENT_PercentServiceConnect]
		--,[CRS].[SPATIENT].[PeriodOfService] AS [SPATIENT_PeriodOfService]
		--,[CRS].[SPATIENT].[PeriodOfServiceIEN] AS [SPATIENT_PeriodOfServiceIEN]
		--,[CRS].[SPATIENT].[PeriodOfServiceSID] AS [SPATIENT_PeriodOfServiceSID]
		--,[CRS].[SPATIENT].[PhoneCellular] AS [SPATIENT_PhoneCellular]
		--,[CRS].[SPATIENT].[PhoneResidence] AS [SPATIENT_PhoneResidence]
		--,[CRS].[SPATIENT].[PhoneWork] AS [SPATIENT_PhoneWork]
		--,[CRS].[SPATIENT].[PostalCode] AS [SPATIENT_PostalCode]
		--,[CRS].[SPATIENT].[POWLocationIEN] AS [SPATIENT_POWLocationIEN]
		--,[CRS].[SPATIENT].[PreferredInstitutionIEN] AS [SPATIENT_PreferredInstitutionIEN]
		--,[CRS].[SPATIENT].[Province] AS [SPATIENT_Province]
		--,[CRS].[SPATIENT].[PseudoSSNFlag] AS [SPATIENT_PseudoSSNFlag]
		--,[CRS].[SPATIENT].[PurpleHeartInstitutionIEN] AS [SPATIENT_PurpleHeartInstitutionIEN]
		--,[CRS].[SPATIENT].[RaceIEN] AS [SPATIENT_RaceIEN]
		--,[CRS].[SPATIENT].[RaceSID] AS [SPATIENT_RaceSID]
		--,[CRS].[SPATIENT].[Religion] AS [SPATIENT_Religion]
		--,[CRS].[SPATIENT].[ReligionIEN] AS [SPATIENT_ReligionIEN]
		--,[CRS].[SPATIENT].[ReligionSID] AS [SPATIENT_ReligionSID]
		--,[CRS].[SPATIENT].[RoomBedIEN] AS [SPATIENT_RoomBedIEN]
		--,[CRS].[SPATIENT].[ScrSSN] AS [SPATIENT_ScrSSN]
		--,[CRS].[SPATIENT].[SensitiveFlag] AS [SPATIENT_SensitiveFlag]
		--,[CRS].[SPATIENT].[Sta3n] AS [SPATIENT_Sta3n]
		--,[CRS].[SPATIENT].[State] AS [SPATIENT_State]
		--,[CRS].[SPATIENT].[StateIEN] AS [SPATIENT_StateIEN]
		--,[CRS].[SPATIENT].[StateSID] AS [SPATIENT_StateSID]
		--,[CRS].[SPATIENT].[STD_COMBATLOCATION_ID] AS [SPATIENT_STD_COMBATLOCATION_ID]
		--,[CRS].[SPATIENT].[STD_ENTHNICITY_ID] AS [SPATIENT_STD_ENTHNICITY_ID]
		--,[CRS].[SPATIENT].[STD_GENDER_ID] AS [SPATIENT_STD_GENDER_ID]
		--,[CRS].[SPATIENT].[STD_MARITALSTATUS_ID] AS [SPATIENT_STD_MARITALSTATUS_ID]
		--,[CRS].[SPATIENT].[STD_RACE_ID] AS [SPATIENT_STD_RACE_ID]
		--,[CRS].[SPATIENT].[STD_SERVICEBRANCH_ID] AS [SPATIENT_STD_SERVICEBRANCH_ID]
		--,[CRS].[SPATIENT].[StdRegistryId] AS [SPATIENT_StdRegistryId]
		--,[CRS].[SPATIENT].[StreetAddress1] AS [SPATIENT_StreetAddress1]
		--,[CRS].[SPATIENT].[StreetAddress2] AS [SPATIENT_StreetAddress2]
		--,[CRS].[SPATIENT].[StreetAddress3] AS [SPATIENT_StreetAddress3]
		--,[CRS].[SPATIENT].[TemporaryAddressChangeInstitutionIEN] AS [SPATIENT_TemporaryAddressChangeInstitutionIEN]
		--,[CRS].[SPATIENT].[Updatedate] AS [SPATIENT_Updatedate]
		--,[CRS].[SPATIENT].[UpdatedBy] AS [SPATIENT_UpdatedBy]
		--,[CRS].[SPATIENT].[VeteranFlag] AS [SPATIENT_VeteranFlag]
		--,[CRS].[SPATIENT].[VistaCreateDate] AS [SPATIENT_VistaCreateDate]
		--,[CRS].[SPATIENT].[VistaEditDate] AS [SPATIENT_VistaEditDate]
		--,[CRS].[SPATIENT].[Zip] AS [SPATIENT_Zip]
		--,[CRS].[SPATIENT].[Zip4] AS [SPATIENT_Zip4]
		

		--,[CRS].[SStaff_SStaff].[City] AS [SStaff_SStaff_City]
		--,[CRS].[SStaff_SStaff].[CommercialPhone] AS [SStaff_SStaff_CommercialPhone]
		--,[CRS].[SStaff_SStaff].[CreatedByStaffSID] AS [SStaff_SStaff_CreatedByStaffSID]
		--,[CRS].[SStaff_SStaff].[DEA] AS [SStaff_SStaff_DEA]
		--,[CRS].[SStaff_SStaff].[Degree] AS [SStaff_SStaff_Degree]
		--,[CRS].[SStaff_SStaff].[DelegateOfStaffIEN] AS [SStaff_SStaff_DelegateOfStaffIEN]
		--,[CRS].[SStaff_SStaff].[DelegateOfStaffSID] AS [SStaff_SStaff_DelegateOfStaffSID]
		--,[CRS].[SStaff_SStaff].[DelegationDate] AS [SStaff_SStaff_DelegationDate]
		--,[CRS].[SStaff_SStaff].[DelegationLevel] AS [SStaff_SStaff_DelegationLevel]
		--,[CRS].[SStaff_SStaff].[DigitalPager] AS [SStaff_SStaff_DigitalPager]
		--,[CRS].[SStaff_SStaff].[ElectronicSignatureCodeFlag] AS [SStaff_SStaff_ElectronicSignatureCodeFlag]
		--,[CRS].[SStaff_SStaff].[EmailAddress] AS [SStaff_SStaff_EmailAddress]
		--,[CRS].[SStaff_SStaff].[EnteredDate] AS [SStaff_SStaff_EnteredDate]
		--,[CRS].[SStaff_SStaff].[ETLBatchID] AS [SStaff_SStaff_ETLBatchID]
		--,[CRS].[SStaff_SStaff].[FaxNumber] AS [SStaff_SStaff_FaxNumber]
		--,[CRS].[SStaff_SStaff].[FirstName] AS [SStaff_SStaff_FirstName]
		--,[CRS].[SStaff_SStaff].[Gender] AS [SStaff_SStaff_Gender]
		--,[CRS].[SStaff_SStaff].[HINQEmployeeNumberFlag] AS [SStaff_SStaff_HINQEmployeeNumberFlag]
		--,[CRS].[SStaff_SStaff].[HomePhone] AS [SStaff_SStaff_HomePhone]
		--,[CRS].[SStaff_SStaff].[InactivationDate] AS [SStaff_SStaff_InactivationDate]
		--,[CRS].[SStaff_SStaff].[LastEditedDateTime] AS [SStaff_SStaff_LastEditedDateTime]
		--,[CRS].[SStaff_SStaff].[LastName] AS [SStaff_SStaff_LastName]
		--,[CRS].[SStaff_SStaff].[LastSignonDateTime] AS [SStaff_SStaff_LastSignonDateTime]
		--,[CRS].[SStaff_SStaff].[LastUsedTerminalType] AS [SStaff_SStaff_LastUsedTerminalType]
		--,[CRS].[SStaff_SStaff].[MailCode] AS [SStaff_SStaff_MailCode]
		--,[CRS].[SStaff_SStaff].[MiddleName] AS [SStaff_SStaff_MiddleName]
		--,[CRS].[SStaff_SStaff].[NetworkUsername] AS [SStaff_SStaff_NetworkUsername]
		--,[CRS].[SStaff_SStaff].[NPI] AS [SStaff_SStaff_NPI]
		--,[CRS].[SStaff_SStaff].[NPIAuthorizedReleaseFlag] AS [SStaff_SStaff_NPIAuthorizedReleaseFlag]
		--,[CRS].[SStaff_SStaff].[OfficePhone] AS [SStaff_SStaff_OfficePhone]
		--,[CRS].[SStaff_SStaff].[OpCode] AS [SStaff_SStaff_OpCode]
		--,[CRS].[SStaff_SStaff].[PACFlag] AS [SStaff_SStaff_PACFlag]
		--,[CRS].[SStaff_SStaff].[Phone3] AS [SStaff_SStaff_Phone3]
		--,[CRS].[SStaff_SStaff].[Phone4] AS [SStaff_SStaff_Phone4]
		--,[CRS].[SStaff_SStaff].[PositionTitle] AS [SStaff_SStaff_PositionTitle]
		--,[CRS].[SStaff_SStaff].[Provider_ID] AS [SStaff_SStaff_Provider_ID]
		--,[CRS].[SStaff_SStaff].[ProviderClass] AS [SStaff_SStaff_ProviderClass]
		--,[CRS].[SStaff_SStaff].[ProviderClassSID] AS [SStaff_SStaff_ProviderClassSID]
		--,[CRS].[SStaff_SStaff].[ProviderScheduleType] AS [SStaff_SStaff_ProviderScheduleType]
		--,[CRS].[SStaff_SStaff].[Room] AS [SStaff_SStaff_Room]
		--,[CRS].[SStaff_SStaff].[ServiceComputationDate] AS [SStaff_SStaff_ServiceComputationDate]
		--,[CRS].[SStaff_SStaff].[ServiceSection] AS [SStaff_SStaff_ServiceSection]
		--,[CRS].[SStaff_SStaff].[ServiceSectionSID] AS [SStaff_SStaff_ServiceSectionSID]
		--,[CRS].[SStaff_SStaff].[ServiceType] AS [SStaff_SStaff_ServiceType]
		--,[CRS].[SStaff_SStaff].[SignatureBlockName] AS [SStaff_SStaff_SignatureBlockName]
		--,[CRS].[SStaff_SStaff].[SignatureBlockTitle] AS [SStaff_SStaff_SignatureBlockTitle]
		--,[CRS].[SStaff_SStaff].[SocialWorkerImmediateSupervisorStaffSID] AS [SStaff_SStaff_SocialWorkerImmediateSupervisorStaffSID]
		--,[CRS].[SStaff_SStaff].[SocialWorkerPositionTitle] AS [SStaff_SStaff_SocialWorkerPositionTitle]
		--,[CRS].[SStaff_SStaff].[Sta3n] AS [SStaff_SStaff_Sta3n]
		--,[CRS].[SStaff_SStaff].[StaffIEN] AS [SStaff_SStaff_StaffIEN]
		--,[CRS].[SStaff_SStaff].[StaffName] AS [SStaff_SStaff_StaffName]
		--,[CRS].[SStaff_SStaff].[StaffNamePrefix] AS [SStaff_SStaff_StaffNamePrefix]
		--,[CRS].[SStaff_SStaff].[StaffNameSuffix] AS [SStaff_SStaff_StaffNameSuffix]
		--,[CRS].[SStaff_SStaff].[StaffSID] AS [SStaff_SStaff_StaffSID]
		--,[CRS].[SStaff_SStaff].[StateName] AS [SStaff_SStaff_StateName]
		--,[CRS].[SStaff_SStaff].[StreetAddress1] AS [SStaff_SStaff_StreetAddress1]
		--,[CRS].[SStaff_SStaff].[StreetAddress2] AS [SStaff_SStaff_StreetAddress2]
		--,[CRS].[SStaff_SStaff].[StreetAddress3] AS [SStaff_SStaff_StreetAddress3]
		--,[CRS].[SStaff_SStaff].[SupplyEmployee] AS [SStaff_SStaff_SupplyEmployee]
		--,[CRS].[SStaff_SStaff].[TemporaryAddress1] AS [SStaff_SStaff_TemporaryAddress1]
		--,[CRS].[SStaff_SStaff].[TemporaryAddress2] AS [SStaff_SStaff_TemporaryAddress2]
		--,[CRS].[SStaff_SStaff].[TemporaryAddress3] AS [SStaff_SStaff_TemporaryAddress3]
		--,[CRS].[SStaff_SStaff].[TemporaryAddressEndDate] AS [SStaff_SStaff_TemporaryAddressEndDate]
		--,[CRS].[SStaff_SStaff].[TemporaryAddressStartDate] AS [SStaff_SStaff_TemporaryAddressStartDate]
		--,[CRS].[SStaff_SStaff].[TemporaryCity] AS [SStaff_SStaff_TemporaryCity]
		--,[CRS].[SStaff_SStaff].[TemporaryStateName] AS [SStaff_SStaff_TemporaryStateName]
		--,[CRS].[SStaff_SStaff].[TemporaryZipCode] AS [SStaff_SStaff_TemporaryZipCode]
		--,[CRS].[SStaff_SStaff].[TerminationDate] AS [SStaff_SStaff_TerminationDate]
		--,[CRS].[SStaff_SStaff].[TerminationReason] AS [SStaff_SStaff_TerminationReason]
		--,[CRS].[SStaff_SStaff].[VANumber] AS [SStaff_SStaff_VANumber]
		--,[CRS].[SStaff_SStaff].[VerifyCodeLastChangedDate] AS [SStaff_SStaff_VerifyCodeLastChangedDate]
		--,[CRS].[SStaff_SStaff].[VistaCreateDate] AS [SStaff_SStaff_VistaCreateDate]
		--,[CRS].[SStaff_SStaff].[VistaEditDate] AS [SStaff_SStaff_VistaEditDate]
		--,[CRS].[SStaff_SStaff].[VoicePager] AS [SStaff_SStaff_VoicePager]
		--,[CRS].[SStaff_SStaff].[ZipCode] AS [SStaff_SStaff_ZipCode]
	FROM 
		[CRS].[REFERRAL]
			--INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			--INNER JOIN [CRS].[STD_REFERRALSTS] ON [CRS].[STD_REFERRALSTS].[ID] = [CRS].[REFERRAL].[STD_REFERRALSTS_ID]
			--LEFT OUTER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[Patient_ID] = [CRS].[PATIENT].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			--LEFT OUTER JOIN [CRS].[SStaff_SStaff] ON [CRS].[SStaff_SStaff].[Provider_ID] = [CRS].[REFERRAL].[Provider_ID]
	WHERE 
		[CRS].[REFERRAL].[STD_REGISTRY_ID] = @CURRENT_REGISTRY_ID 
		AND (@STD_REFERRALSTS_ID = 0 OR  [CRS].[REFERRAL].[STD_REFERRALSTS_ID] = @STD_REFERRALSTS_ID);
*/
END

GO


-- =============================================
-- Author:        
-- Create date:   12/28/2015
-- Description:   Get all records by Registry and Status
---               Updated Stored Procedure to Display either Zip or PostalCode from SPATIENT table.
-- =============================================
ALTER PROCEDURE [CRS].[usp_REFERRAL_getitemsCommonByRegistry] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_REFERRAL_getitemsByRegistryStatus', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT * FROM (
	SELECT 
		ROW_NUMBER() OVER(PARTITION BY [CRS].[REFERRAL].[REFERRAL_ID] ORDER BY [CRS].[REFERRAL].[REFERRAL_ID] DESC) AS [Row]
		,[CRS].[REFERRAL].[PROVIDER_ID] AS [REFERRAL_PROVIDER_ID]
		,[CRS].[REFERRAL].[REFERRAL_DATE] AS [REFERRAL_REFERRAL_DATE]
		,[CRS].[REFERRAL].[REFERRAL_ID] AS [REFERRAL_REFERRAL_ID]
		,[CRS].[REFERRAL].[PATIENT_ID] AS [REFERRAL_PATIENT_ID]

		,[CRS].[STD_REGISTRY].[NAME] AS [STD_REGISTRY_NAME]

		,[CRS].[PATIENT].[BIRTH_DATE] AS [PATIENT_BIRTH_DATE]
		,[CRS].[PATIENT].[FIRST_NAME] AS [PATIENT_FIRST_NAME]
		,[CRS].[PATIENT].[LAST_NAME] AS [PATIENT_LAST_NAME]

		,[CRS].[STD_REFERRALSTS].[CODE] AS [STD_REFERRALSTS_CODE]

		,[CRS].[SPATIENT].[City] AS [SPATIENT_City]
		,[CRS].[SPATIENT].[Gender] AS [SPATIENT_Gender]
		,ISNULL([CRS].[SPATIENT].[PostalCode],[CRS].[SPATIENT].[Zip])  AS [SPATIENT_PostalCode]
		,[CRS].[SPATIENT].[State] AS [SPATIENT_State]
		,RIGHT(ISNULL([CRS].[SPATIENT].[PatientSSN], '0000'), 4) AS [SPATIENT_PatientLastFour]
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[STD_REFERRALSTS] ON [CRS].[STD_REFERRALSTS].[ID] = [CRS].[REFERRAL].[STD_REFERRALSTS_ID]
			LEFT OUTER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
	WHERE 
		[CRS].[REFERRAL].[STD_REGISTRY_ID] = @CURRENT_REGISTRY_ID) t WHERE t.[Row] = 1;
END


GO



-- =============================================
-- Author:        
-- Create date:   12/28/2015
-- Description:   Get all records by Registry and Status
---               Updated Stored Procedure to Display either Zip or PostalCode from SPATIENT table.
-- =============================================
ALTER PROCEDURE [CRS].[usp_REFERRAL_getitemsCommonByRegistry_optomized] (@CURRENT_USER VARCHAR(30), @CURRENT_REGISTRY_ID INT)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_REFERRAL_getitemsByRegistryStatus', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg AS [ErrorMsg];
		RETURN
	END

	SELECT 
		[CRS].[REFERRAL].[PROVIDER_ID] AS [REFERRAL_PROVIDER_ID]
		,[CRS].[REFERRAL].[REFERRAL_DATE] AS [REFERRAL_REFERRAL_DATE]
		,[CRS].[REFERRAL].[REFERRAL_ID] AS [REFERRAL_REFERRAL_ID]

		,[CRS].[PATIENT].[BIRTH_DATE] AS [PATIENT_BIRTH_DATE]
		,[CRS].[PATIENT].[FIRST_NAME] AS [PATIENT_FIRST_NAME]
		,[CRS].[PATIENT].[LAST_NAME] AS [PATIENT_LAST_NAME]
		,[CRS].[PATIENT].[PATIENT_ID] AS [PATIENT_PATIENT_ID]

		,[CRS].[STD_REFERRALSTS].[CODE] AS [STD_REFERRALSTS_CODE]

		,[CRS].[SPATIENT].[City] AS [SPATIENT_City]
		,[CRS].[SPATIENT].[Gender] AS [SPATIENT_Gender]
		,ISNULL([CRS].[SPATIENT].[PostalCode],[CRS].[SPATIENT].[Zip])  AS [SPATIENT_PostalCode]
		,[CRS].[SPATIENT].[State] AS [SPATIENT_State]
		,RIGHT(ISNULL([CRS].[SPATIENT].[PatientSSN], '0000'), 4) AS [SPATIENT_PatientLastFour]
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[STD_REFERRALSTS] ON [CRS].[STD_REFERRALSTS].[ID] = [CRS].[REFERRAL].[STD_REFERRALSTS_ID]
			--LEFT OUTER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
	WHERE 
		[CRS].[REFERRAL].[STD_REGISTRY_ID] = 32--@CURRENT_REGISTRY_ID;
END


GO

-- =============================================
-- Author:        
-- Create date:   07/18/2016
-- Description:   Save/Update a record
---               Updated Stored Procedure to Display either Zip or PostalCode from SPATIENT table.
-- =============================================
ALTER PROCEDURE [CRS].[usp_SPATIENT_save]
			(@CURRENT_USER varchar(30), 
			@CURRENT_REGISTRY_ID int,
			@AddressChangeInstitutionIEN varchar(50), 
			@AddressChangeInstitutionSID int, 
			@AddressChangeStaffIEN varchar(50),
			@AddressChangeStaffSID int,
			@Age numeric(18,0),
			@BadAddressIndicator varchar(50), 
			@CDDeterminingInstitutionIEN varchar(50), 
			@City varchar(50), 
			@CombatFromVistaDate varchar(50),
			@CombatToVistaDate varchar(50), 
			@ConfidentialAddressActiveFlag char(1), 
			@Country varchar(100),
			@CountryIEN varchar(50), 
			@CountrySID int, 
			@County varchar(50),
			@Created datetime, 
			@CreatedBy varchar(30), 
			@CurrentMeansTestStatusIEN varchar(50), 
			@DateOfBirth date,
			@DateOfBirthText varchar(50), 
			@DateOfDeath date, 
			@DateOfDeathText varchar(50),
			@Deceased char(1), 
			@DEFAULT_RECORD bit, 
			@Eligibility varchar(50),
			@EligibilityIEN varchar(50),
			@EligibilitySID int, 
			@EligibilityStatus varchar(50), 
			@EligibilityVACode numeric(18,0), 
			@EligibilityVerificationSource varchar(50),
			@EmailAddress varchar(50), 
			@EnteredIntoFileDate date,
			@EnteredIntoFileDateTransformSID bigint,
			@EnteredIntoFileVistaErrorDate varchar(50), 
			@ETLBatchID int, 
			@ExcludeFromFacilityDirectoryFlag char(1),
			@Gender char(1), 
			@GISAddressType varchar(50),
			@GISAddressUpdatedDate date, 
			@GISCongressDistrict varchar(50),
			@GISFIPSCode varchar(50), 
			@GISLocatorName varchar(50), 
			@GISMarket varchar(50),
			@GISMatchedAddress varchar(50),
			@GISMatchMethodCode varchar(50),
			@GISMatchScore int, 
			@GISMatchStatusCode varchar(50),
			@GISPatientAddressLatitude float, 
			@GISPatientAddressLongitude float,
			@GISSector varchar(50),
			@GISStreetSide varchar(50),
			@GISSubmarket varchar(50), 
			@GISURH char(1), 
			@InsuranceCoverageFlag char(1), 
			@LastServiceEntryDate date,
			@LastServiceEntryDateTransformSID bigint,
			@LastServiceEntryVistaErrorDate varchar(50), 
			@LastServiceSeparationDate date,
			@LastServiceSeparationDateTransformSID bigint, 
			@LastServiceSeparationVistaErrorDate varchar(50), 
			@MaritalStatus varchar(25),
			@MaritalStatusIEN varchar(50),
			@MaritalStatusSID int,
			@MedicaidNumber varchar(50), 
			@MothersMaidenName varchar(50),
			@OEF_OIF_IND bit, 
			@OpCode char(1), 
			@Patient_ID int, 
			@PatientFirstName varchar(50),
			@PatientICN varchar(50), 
			@PatientICNChecksum varchar(50), 
			@PatientIEN varchar(50),
			@PatientLastName varchar(50), 
			@PatientName varchar(100), 
			@PatientSID int, 
			@PatientSSN varchar(50), 
			@PercentServiceConnect int, 
			@PeriodOfService varchar(50),
			@PeriodOfServiceIEN varchar(50), 
			@PeriodOfServiceSID int, 
			@PhoneCellular varchar(50), 
			@PhoneResidence varchar(50), 
			@PhoneWork varchar(50),
			@PK_ID int output,
			@PostalCode varchar(50),
			@POWLocationIEN varchar(50), 
			@PreferredInstitutionIEN varchar(50), 
			@Province varchar(50), 
			@PseudoSSNFlag char(1), 
			@PurpleHeartInstitutionIEN varchar(50), 
			@Race varchar(45), @RaceIEN varchar(50),
			@RaceSID int, @Religion varchar(30),
			@ReligionIEN varchar(50), 
			@ReligionSID int, 
			@RoomBedIEN varchar(50),
			@ScrSSN varchar(50), 
			@SensitiveFlag char(1), 
			@Sta3n smallint,
			@State varchar(30), 
			@StateIEN varchar(50),
			@StateSID int,
			@STD_COMBATLOCATION_ID int, 
			@STD_ENTHNICITY_ID int,
			@STD_GENDER_ID int,
			@STD_MARITALSTATUS_ID int, 
			@STD_RACE_ID int, 
			@STD_SERVICEBRANCH_ID int, 
			@StdRegistryId int,
			@StreetAddress1 varchar(50), 
			@StreetAddress2 varchar(50),
			@StreetAddress3 varchar(50),
			@TemporaryAddressChangeInstitutionIEN varchar(50), 
			@Updatedate datetime, 
			@UpdatedBy varchar(30),
			@VeteranFlag char(1), 
			@VistaCreateDate datetime, 
			@VistaEditDate datetime,
			@Zip varchar(50), 
			@Zip4 varchar(50))
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_SPATIENT_save', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	IF ISNULL(@PK_ID,0) = 0
		BEGIN
			-- if insert then set CREATED to current date time
			SET @CREATED = GetDate();
			-- if insert then set UPDATED to current date time
			SET @Updatedate = GetDate();
			INSERT INTO [CRS].[SPATIENT] ([AddressChangeInstitutionIEN], [AddressChangeInstitutionSID], [AddressChangeStaffIEN], 
				[AddressChangeStaffSID], [Age], [BadAddressIndicator], [CDDeterminingInstitutionIEN], [City], [CombatFromVistaDate], 
				[CombatToVistaDate], [ConfidentialAddressActiveFlag], [Country], [CountryIEN], [CountrySID], [County],
				[Created], [CreatedBy], [CurrentMeansTestStatusIEN], [DateOfBirth], [DateOfBirthText], [DateOfDeath],
				[DateOfDeathText], [Deceased], [DEFAULT_RECORD], [Eligibility], [EligibilityIEN], [EligibilitySID], 
				[EligibilityStatus], [EligibilityVACode], [EligibilityVerificationSource], [EmailAddress], [EnteredIntoFileDate],	
				[EnteredIntoFileDateTransformSID], [EnteredIntoFileVistaErrorDate],
				[ETLBatchID], [ExcludeFromFacilityDirectoryFlag], [Gender], [GISAddressType], [GISAddressUpdatedDate], [GISCongressDistrict], [GISFIPSCode], 
				[GISLocatorName], [GISMarket], [GISMatchedAddress], [GISMatchMethodCode], [GISMatchScore],
				[GISMatchStatusCode], [GISPatientAddressLatitude], [GISPatientAddressLongitude], [GISSector], [GISStreetSide], [GISSubmarket], [GISURH], [InsuranceCoverageFlag],
				[LastServiceEntryDate], [LastServiceEntryDateTransformSID], [LastServiceEntryVistaErrorDate],
				[LastServiceSeparationDate], [LastServiceSeparationDateTransformSID], [LastServiceSeparationVistaErrorDate], [MaritalStatus], [MaritalStatusIEN], 
				[MaritalStatusSID], [MedicaidNumber], [MothersMaidenName], [OEF_OIF_IND], [OpCode], 
				[Patient_ID], [PatientFirstName], [PatientICN], [PatientICNChecksum], [PatientIEN], [PatientLastName], [PatientName], [PatientSID], [PatientSSN], [PercentServiceConnect], 
				[PeriodOfService], [PeriodOfServiceIEN], [PeriodOfServiceSID], [PhoneCellular], [PhoneResidence],
				 [PhoneWork], [PostalCode], [POWLocationIEN], [PreferredInstitutionIEN], [Province], [PseudoSSNFlag], 
				[PurpleHeartInstitutionIEN], [Race], [RaceIEN], [RaceSID], [Religion], [ReligionIEN], 
				[ReligionSID], [RoomBedIEN], [ScrSSN], [SensitiveFlag], [Sta3n], [State], [StateIEN],
				[StateSID], [STD_COMBATLOCATION_ID], [STD_ENTHNICITY_ID]
				, [STD_GENDER_ID], [STD_MARITALSTATUS_ID], [STD_RACE_ID], [STD_SERVICEBRANCH_ID],
				[StdRegistryId], [StreetAddress1], [StreetAddress2], [StreetAddress3],
				[TemporaryAddressChangeInstitutionIEN], [Updatedate], [UpdatedBy], [VeteranFlag], [VistaCreateDate], [VistaEditDate], [Zip], [Zip4])
			VALUES (@AddressChangeInstitutionIEN,
				@AddressChangeInstitutionSID,
				@AddressChangeStaffIEN,
				@AddressChangeStaffSID,
				@Age, 
				@BadAddressIndicator, 
				@CDDeterminingInstitutionIEN,
				@City, 
				@CombatFromVistaDate, 
				@CombatToVistaDate, 
				@ConfidentialAddressActiveFlag,
				@Country, 
				@CountryIEN, 
				@CountrySID, 
				@County, 
				@Created, 
				@CreatedBy,
				@CurrentMeansTestStatusIEN, 
				@DateOfBirth, 
				@DateOfBirthText, 
				@DateOfDeath, @DateOfDeathText, @Deceased, @DEFAULT_RECORD, 
				@Eligibility, @EligibilityIEN, @EligibilitySID, @EligibilityStatus, 
				@EligibilityVACode, @EligibilityVerificationSource, @EmailAddress, @EnteredIntoFileDate, 
				@EnteredIntoFileDateTransformSID, @EnteredIntoFileVistaErrorDate, @ETLBatchID, @ExcludeFromFacilityDirectoryFlag,
				@Gender, @GISAddressType, @GISAddressUpdatedDate,@GISCongressDistrict, @GISFIPSCode, @GISLocatorName, 
				@GISMarket, @GISMatchedAddress, @GISMatchMethodCode,	
				@GISMatchScore, @GISMatchStatusCode, @GISPatientAddressLatitude, 
				@GISPatientAddressLongitude, @GISSector,
				@GISStreetSide, @GISSubmarket, @GISURH, @InsuranceCoverageFlag, @LastServiceEntryDate, @LastServiceEntryDateTransformSID,
				@LastServiceEntryVistaErrorDate, @LastServiceSeparationDate,
				@LastServiceSeparationDateTransformSID, @LastServiceSeparationVistaErrorDate,
				@MaritalStatus, @MaritalStatusIEN, @MaritalStatusSID, @MedicaidNumber, @MothersMaidenName,
				@OEF_OIF_IND, @OpCode, @Patient_ID, @PatientFirstName, 
				@PatientICN, @PatientICNChecksum, @PatientIEN, @PatientLastName, @PatientName, 
				@PatientSID, @PatientSSN, @PercentServiceConnect, @PeriodOfService
				, @PeriodOfServiceIEN, @PeriodOfServiceSID, @PhoneCellular, @PhoneResidence,
				@PhoneWork, ISNULL(@PostalCode,@Zip), @POWLocationIEN, @PreferredInstitutionIEN, 
				@Province, @PseudoSSNFlag, @PurpleHeartInstitutionIEN, @Race, 
				@RaceIEN, @RaceSID, @Religion, @ReligionIEN, @ReligionSID, @RoomBedIEN, @ScrSSN, @SensitiveFlag, @Sta3n, 
				@State, @StateIEN, @StateSID, @STD_COMBATLOCATION_ID, @STD_ENTHNICITY_ID,
				@STD_GENDER_ID, @STD_MARITALSTATUS_ID, @STD_RACE_ID, @STD_SERVICEBRANCH_ID,
				@StdRegistryId, @StreetAddress1, @StreetAddress2
				, @StreetAddress3, @TemporaryAddressChangeInstitutionIEN, @Updatedate,
				@UpdatedBy, @VeteranFlag, @VistaCreateDate, @VistaEditDate, ISNULL(@Zip,@PostalCode), @Zip4);
			SELECT @PK_ID = SCOPE_IDENTITY();
		END
	ELSE
		BEGIN
			DECLARE @OldValues varchar(max), @NewValues varchar(max);
			SELECT @OldValues = '<AddressChangeInstitutionIEN>' + ISNULL(CAST([AddressChangeInstitutionIEN] AS varchar), '') +
			 '</AddressChangeInstitutionIEN><AddressChangeInstitutionSID>' + ISNULL(CAST([AddressChangeInstitutionSID] AS varchar), '') + 
			 '</AddressChangeInstitutionSID><AddressChangeStaffIEN>' + ISNULL(CAST([AddressChangeStaffIEN] AS varchar), '') +
			  '</AddressChangeStaffIEN><AddressChangeStaffSID>' + ISNULL(CAST([AddressChangeStaffSID] AS varchar), '') + 
			  '</AddressChangeStaffSID><Age>' + ISNULL(CAST([Age] AS varchar), '') + '</Age><BadAddressIndicator>' + 
			  ISNULL(CAST([BadAddressIndicator] AS varchar), '') + '</BadAddressIndicator><CDDeterminingInstitutionIEN>' + 
			  ISNULL(CAST([CDDeterminingInstitutionIEN] AS varchar), '') + '</CDDeterminingInstitutionIEN><City>' + 
			  ISNULL(CAST([City] AS varchar), '') + '</City><CombatFromVistaDate>' + ISNULL(CAST([CombatFromVistaDate] AS varchar), '') 
			  + '</CombatFromVistaDate><CombatToVistaDate>' + ISNULL(CAST([CombatToVistaDate] AS varchar), '') + 
			  '</CombatToVistaDate><ConfidentialAddressActiveFlag>' + ISNULL(CAST([ConfidentialAddressActiveFlag] AS varchar), '') + 
			  '</ConfidentialAddressActiveFlag><Country>' + ISNULL(CAST([Country] AS varchar), '') + '</Country><CountryIEN>' + 
			  ISNULL(CAST([CountryIEN] AS varchar), '') + 
'</CountryIEN><CountrySID>' + ISNULL(CAST([CountrySID] AS varchar), '') + '</CountrySID><County>' +
 ISNULL(CAST([County] AS varchar), '') +
 '</County><Created>' + ISNULL(CAST([Created] AS varchar), '') + '</Created><CreatedBy>' +
  ISNULL(CAST([CreatedBy] AS varchar), '') + 
'</CreatedBy><CurrentMeansTestStatusIEN>' + ISNULL(CAST([CurrentMeansTestStatusIEN] AS varchar), '') + 
'</CurrentMeansTestStatusIEN><DateOfBirth>' + ISNULL(CAST([DateOfBirth] AS varchar), '') + '</DateOfBirth><DateOfBirthText>' +
 ISNULL(CAST([DateOfBirthText] AS varchar), '') + '</DateOfBirthText><DateOfDeath>' +
 ISNULL(CAST([DateOfDeath] AS varchar), '') + '</DateOfDeath><DateOfDeathText>' +
  ISNULL(CAST([DateOfDeathText] AS varchar), '') +
  '</DateOfDeathText><Deceased>' + ISNULL(CAST([Deceased] AS varchar), '') + 
  '</Deceased><DEFAULT_RECORD>' + ISNULL(CAST([DEFAULT_RECORD] AS varchar), '') + 
  '</DEFAULT_RECORD><Eligibility>' + ISNULL(CAST([Eligibility] AS varchar), '') + 
  '</Eligibility><EligibilityIEN>' + ISNULL(CAST([EligibilityIEN] AS 
varchar), '') + '</EligibilityIEN><EligibilitySID>' + ISNULL(CAST([EligibilitySID] AS varchar), '') +
 '</EligibilitySID><EligibilityStatus>' + ISNULL(CAST([EligibilityStatus] AS varchar), '') +
  '</EligibilityStatus><EligibilityVACode>' + ISNULL(CAST([EligibilityVACode] AS varchar), '') +
   '</EligibilityVACode><EligibilityVerificationSource>' + ISNULL(CAST([EligibilityVerificationSource] AS varchar), '') +
    '</EligibilityVerificationSource><EmailAddress>' + ISNULL(CAST([EmailAddress] AS varchar), '') +
    '</EmailAddress><EnteredIntoFileDate>' + ISNULL(CAST([EnteredIntoFileDate] AS varchar), '') + 
'</EnteredIntoFileDate><EnteredIntoFileDateTransformSID>' + ISNULL(CAST([EnteredIntoFileDateTransformSID] AS varchar), '') +
 '</EnteredIntoFileDateTransformSID><EnteredIntoFileVistaErrorDate>' + ISNULL(CAST([EnteredIntoFileVistaErrorDate] AS varchar), '') + 
'</EnteredIntoFileVistaErrorDate><ETLBatchID>' + ISNULL(CAST([ETLBatchID] AS varchar), '') + 
'</ETLBatchID><ExcludeFromFacilityDirectoryFlag>' + ISNULL(CAST([ExcludeFromFacilityDirectoryFlag] AS varchar), '') + '</ExcludeFromFacilityDirectoryFlag><Gender>' + 
ISNULL(CAST([Gender] AS varchar), '') + '</Gender><GISAddressType>' + ISNULL(CAST([GISAddressType] AS varchar), '') + 
'</GISAddressType><GISAddressUpdatedDate>
' + ISNULL(CAST([GISAddressUpdatedDate] AS varchar), '') + '</GISAddressUpdatedDate><GISCongressDistrict>' + 
ISNULL(CAST([GISCongressDistrict] AS varchar), '') + '</GISCongressDistrict><GISFIPSCode>' +
 ISNULL(CAST([GISFIPSCode] AS varchar), '') + '</GISFIPSCode><GISLocatorName>' + ISNULL(CAST([GISLocatorName] AS varchar), '') +
  '</GISLocatorName><GISMarket>' + ISNULL(CAST([GISMarket] AS varchar), '') + '</GISMarket><GISMatchedAddress>' +
   ISNULL(CAST([GISMatchedAddress] AS varchar), '') +
  '</GISMatchedAddress><GISMatchMethodCode>' + ISNULL(CAST([GISMatchMethodCode] AS varchar), '') + 
  '</GISMatchMethodCode><GISMatchScore>' +
   ISNULL(CAST([GISMatchScore] AS varchar), '') + '</GISMatchScore><GISMatchStatusCode>' +
    ISNULL(CAST([GISMatchStatusCode] AS varchar), '') + '</GISMatchStatusCode><GISPatientAddressLatitude>' + 
	ISNULL(CAST([GISPatientAddressLatitude] AS varchar), '') + '</GISPatientAddressLatitude><GISPatientAddressLongitude>' + 
	ISNULL(CAST([GISPatientAddressLongitude] AS varchar), '') + '</GISPatientAddressLongitude><GISSector>' +
	 ISNULL(CAST([GISSector] AS varchar), '') +
	 '</GISSector><GISStreetSide>' +
 ISNULL(CAST([GISStreetSide] AS varchar), '') + '</GISStreetSide><GISSubmarket>' + ISNULL(CAST([GISSubmarket] AS varchar), '') +
  '</GISSubmarket><GISURH>' + ISNULL(CAST([GISURH] AS varchar), '') + '</GISURH><InsuranceCoverageFlag>' +
   ISNULL(CAST([InsuranceCoverageFlag] AS varchar), '') + '</InsuranceCoverageFlag><LastServiceEntryDate>' + ISNULL(CAST([LastServiceEntryDate] AS varchar), '') +
   '</LastServiceEntryDate><LastServiceEntryDateTransformSID>' + ISNULL(CAST([LastServiceEntryDateTransformSID] AS varchar), '') + 
   '</LastServiceEntryDateTransformSID><LastServiceEntryVistaErrorDate>' + ISNULL(CAST([LastServiceEntryVistaErrorDate] AS varchar), '') +
    '</LastServiceEntryVistaErrorDate><LastServiceSeparationDate>' + ISNULL(CAST([LastServiceSeparationDate] AS varchar), '') +
	 '</LastServiceSeparationDate><LastServiceSeparationDateTransformSID>' + ISNULL(CAST([LastServiceSeparationDateTransformSID] AS varchar), '') +
	  '</LastServiceSeparationDateTransformSID><LastServiceSeparationVistaErrorDate>' + 
	  ISNULL(CAST([LastServiceSeparationVistaErrorDate] AS varchar), '') +
	   '</LastServiceSeparationVistaErrorDate><MaritalStatus>' + ISNULL(CAST([MaritalStatus] AS varchar), '') + '</MaritalStatus><MaritalStatusIEN>' +
	    ISNULL(CAST([MaritalStatusIEN] AS varchar), '') +
 '</MaritalStatusIEN><MaritalStatusSID>' + ISNULL(CAST([MaritalStatusSID] AS varchar), '') +
  '</MaritalStatusSID><MedicaidNumber>' + ISNULL(CAST([MedicaidNumber] AS varchar), '') + 
  '</MedicaidNumber><MothersMaidenName>' + 
ISNULL(CAST([MothersMaidenName] AS varchar), '') + '</MothersMaidenName><OEF_OIF_IND>' + 
ISNULL(CAST([OEF_OIF_IND] AS varchar), '') + '</OEF_OIF_IND><OpCode>' + ISNULL(CAST([OpCode] AS varchar), '') + 
'</OpCode><Patient_ID>' + ISNULL(CAST([Patient_ID] AS varchar), '') + '</Patient_ID><PatientFirstName>' + 
ISNULL(CAST([PatientFirstName] AS varchar), '') + '</PatientFirstName><PatientICN>' + ISNULL(CAST([PatientICN] AS varchar), '') + '</Patien
tICN><PatientICNChecksum>' + ISNULL(CAST([PatientICNChecksum] AS varchar), '') + 
'</PatientICNChecksum><PatientIEN>' + ISNULL(CAST([PatientIEN] AS varchar), '') + '</PatientIEN><PatientLastName>' +
 ISNULL(CAST([PatientLastName] AS varchar), '') + '</PatientLastName><PatientName>' + ISNULL(CAST([PatientName] AS varchar), '') + 
 '</PatientName><PatientSID>' + ISNULL(CAST([PatientSID] AS varchar), '') + '</PatientSID><PatientSSN>' +
  ISNULL(CAST([PatientSSN] AS varchar), '') + '</PatientSSN><PercentServiceConnect>' + 
  ISNULL(CAST([PercentServiceConnect] AS varchar), '') + '</PercentServiceConnect><PeriodOfService>' + ISNULL(CAST([PeriodOfService] AS varchar), '') +
   '</PeriodOfService><PeriodOfServiceIEN>' + ISNULL(CAST([PeriodOfServiceIEN] AS varchar), '') + '<
/PeriodOfServiceIEN><PeriodOfServiceSID>' + ISNULL(CAST([PeriodOfServiceSID] AS varchar), '') + 
'</PeriodOfServiceSID><PhoneCellular>' + ISNULL(CAST([PhoneCellular] AS varchar), '') + 
'</PhoneCellular><PhoneResidence>' + ISNULL(CAST([PhoneResidence] AS varchar), '') + '</PhoneResidence><PhoneWork>' +
 ISNULL(CAST([PhoneWork] AS varchar), '') + '</PhoneWork><PK_ID>' + ISNULL(CAST([PK_ID] AS varchar), '') + '</PK_ID><PostalCode>' + 
ISNULL(CAST([PostalCode] AS varchar), '') + '</PostalCode><POWLocationIEN>' +
 ISNULL(CAST([POWLocationIEN] AS varchar), '') + '</POWLocationIEN><PreferredInstitutionIEN>' +
  ISNULL(CAST([PreferredInstitutionIEN] AS varchar), '') + '</PreferredInstitutionIEN><Province>' + 
  ISNULL(CAST([Province] AS varchar), '') +
   '</Province><PseudoSSNFlag>' + ISNULL(CAST([PseudoSSNFlag] AS varchar), '') + 
   '</PseudoSSNFlag><PurpleHeartInstitutionIEN>' + ISNULL(CAST([PurpleHeartInstitutionIEN] AS varchar), '') +
    '</PurpleHeartInstitutionIEN><Race>' + ISNULL(CAST([Race] AS varchar), '') +
	 '</Race><RaceIEN>' + ISNULL(CAST([RaceIEN] AS varchar), '') + '</RaceIEN><RaceSID>' +
	  ISNULL(CAST([RaceSID] AS varchar), '') + '</RaceSID><Religion>' + ISNULL(CAST([Religion] AS varchar), '') + '</Religion><ReligionIEN>' + 
	  ISNULL(CAST([ReligionIEN] AS varchar), '') +
 '</ReligionIEN><ReligionSID>' + ISNULL(CAST([ReligionSID] AS varchar), '') + '</ReligionSID><RoomBedIEN>' +
  ISNULL(CAST([RoomBedIEN] AS varchar), '') + '</RoomBedIEN><ScrSSN>' + ISNULL(CAST([ScrSSN] AS varchar), '') + '</ScrSSN><SensitiveFlag>' + ISNULL(
CAST([SensitiveFlag] AS varchar), '') + '</SensitiveFlag><Sta3n>' + ISNULL(CAST([Sta3n] AS varchar), '') +
 '</Sta3n><State>' + ISNULL(CAST([State] AS varchar), '') + '</State><StateIEN>' + ISNULL(CAST([StateIEN] AS varchar), '') + '</StateIEN><StateSID>' 
+ ISNULL(CAST([StateSID] AS varchar), '') + '</StateSID><STD_COMBATLOCATION_ID>' + 
ISNULL(CAST([STD_COMBATLOCATION_ID] AS varchar), '') + '</STD_COMBATLOCATION_ID><STD_ENTHNICITY_ID>' +
 ISNULL(CAST([STD_ENTHNICITY_ID] AS varchar), '') + '</STD_ENTHNICITY_ID><STD_GENDER_ID>' + ISNULL(CAST([STD_GENDER_ID] AS varchar), '') +
 '</STD_GENDER_ID><STD_MARITALSTATUS_ID>' + ISNULL(CAST([STD_MARITALSTATUS_ID] AS varchar), '') + '</STD_MARITALSTATUS_ID><STD_RACE_ID>' + ISNULL(CAST([STD_RACE_ID] AS varchar), '') + 
 '</STD_RACE_ID><STD_SERVICEBRANCH_ID>' + ISNULL(CAST([STD_SERVICEBRANCH_ID] AS varchar), '') +
  '</STD_SERVICEBRANCH_ID><StdRegistryId>' + ISNULL(CAST([StdRegistryId] AS varchar), '') +
   '</StdRegistryId><StreetAddress1>' + ISNULL(CAST([StreetAddress1] AS varchar), '') +
    '</StreetAddress1><StreetAddress2>' + ISNULL(CAST([StreetAddress2] AS varchar), '') + 
  '</StreetAddress2><StreetAddress3>' + ISNULL(CAST([StreetAddress3] AS varchar), '') +
   '</StreetAddress3><TemporaryAddressChangeInstitutionIEN>' + ISNULL(CAST([TemporaryAddressChangeInstitutionIEN] AS varchar), '') + 
  '</TemporaryAddressChangeInstitutionIEN><Updatedate>' +
   ISNULL(CAST([Updatedate] AS varchar), '') + '</Updatedate><UpdatedBy>' +
 ISNULL(CAST([UpdatedBy] AS varchar), '') + '</UpdatedBy><VeteranFlag>' + 
 ISNULL(CAST([VeteranFlag] AS varchar), '') + '</VeteranFlag><VistaCreateDate>' + ISNULL(CAST([VistaCreateDate] AS varchar), '') +
  '</VistaCreateDate><VistaEditDate>' + ISNULL(CAST([VistaEditDate] AS varchar), '') + '</VistaEditDate><Zip>' + 
  ISNULL(CAST([Zip] AS varchar), '') +
   '</Zip><Zip4>' + ISNULL(CAST([Zip4] AS varchar), '') + '</Zip4>' FROM [CRS].[SPATIENT] WHERE [PK_ID] = @PK_ID;
			SELECT @NewValues = '<AddressChangeInstitutionIEN>' + ISNULL(CAST(@AddressChangeInstitutionIEN AS varchar), '') +
			 '</AddressChangeInstitutionIEN><AddressChangeInstitutionSID>' + ISNULL(CAST(@AddressChangeInstitutionSID AS varchar), '') + '</AddressChan
geInstitutionSID><AddressChangeStaffIEN>' + ISNULL(CAST(@AddressChangeStaffIEN AS varchar), '') +
 '</AddressChangeStaffIEN><AddressChangeStaffSID>' + ISNULL(CAST(@AddressChangeStaffSID AS varchar), '') +
  '</AddressChangeStaffSID><Age>' + ISNULL(CAST(@Age AS varchar), '') + '</Age><BadAddressIndicator>' + ISNULL(CAST(@BadAddressIndicator AS varchar), '') +
 '</BadAddressIndicator><CDDeterminingInstitutionIEN>' + ISNULL(CAST(@CDDeterminingInstitutionIEN AS varchar), '') + '</CDDeterminingInstitutionIEN><City
>' + ISNULL(CAST(@City AS varchar), '') + '</City><CombatFromVistaDate>' + ISNULL(CAST(@CombatFromVistaDate AS varchar), '') +
 '</CombatFromVistaDate><CombatToVistaDate>' + ISNULL(CAST(@CombatToVistaDate AS varchar), '') + '</CombatToVistaDate><ConfidentialAddressActiveFlag>' +
 ISNULL(CAST(@ConfidentialAddressActiveFlag AS varchar), '') + '</ConfidentialAddressActiveFlag><Country>' + ISNULL(CAST(@Country AS varchar), '') +
  '</Country><CountryIEN>' + ISNULL(CAST(@CountryIEN AS varchar), '') + '</CountryIEN
><CountrySID>' + ISNULL(CAST(@CountrySID AS varchar), '') + '</CountrySID><County>' +
 ISNULL(CAST(@County AS varchar), '') + '</County><Created>' + ISNULL(CAST(@Created AS varchar), '') +
  '</Created><CreatedBy>' + ISNULL(CAST(@CreatedBy AS varchar), '') +
 '</CreatedBy><CurrentMeansTestStatusIEN>' + ISNULL(CAST(@CurrentMeansTestStatusIEN AS varchar), '') +
  '</CurrentMeansTestStatusIEN><DateOfBirth>' + ISNULL(CAST(@DateOfBirth AS varchar), '') + 
  '</DateOfBirth><DateOfBirthText>' + ISNULL(CAST(@DateOfBirthText AS varchar), '') + '</DateOfBirthText><DateOfDeath>' + ISNULL(CAST(@DateOfDeath AS varchar), '') +
   '</DateOfDeath><DateOfDeathText>' + ISNULL(CAST(@DateOfDeathText AS varchar), '') + 
  '</DateOfDeathText><Deceased>' + ISNULL(CAST(@Deceased AS varchar), '') + '</Deceased><DEFAULT_RECORD>' + ISNULL(CAST(@DEFAULT_RECORD AS varchar), '') +
   '</DEFAULT_RECORD><Eligibility>' + ISNULL(CAST(@Eligibility AS varchar), '') +
 '</Eligibility><EligibilityIEN>' + ISNULL(CAST(@EligibilityIEN AS varchar), '') +
 '</EligibilityIEN><EligibilitySID>' + ISNULL(CAST(@EligibilitySID AS varchar), '') +
  '</EligibilitySID><EligibilityStatus>' + ISNULL(CAST(@EligibilityStatus AS varchar), '') + '</EligibilityStatus><EligibilityVACode>' +
   ISNULL(CAST(@EligibilityVACode AS varchar), '') + '</EligibilityVACode><EligibilityVerificationSource>' +
   ISNULL(CAST(@EligibilityVerificationSource AS varchar), '') + '</EligibilityVerificationSource><EmailAddress>' + ISNULL(CAST(@EmailAddress AS varchar), '') +
    '</EmailAddress><EnteredIntoFileDate>' + ISNULL(CAST(@EnteredIntoFileDate AS varchar), '') + '</EnteredIntoFileDate><EnteredIntoFileDateTransformSID>' +
 ISNULL(CAST(@EnteredIntoFileDateTransformSID AS varchar), '') + '</EnteredIntoFileDateTransformSID><EnteredIntoFileVistaErrorDate>' + 
 ISNULL(CAST(@EnteredIntoFileVistaErrorDate AS varchar), '') + '</EnteredIntoFileVistaErrorDate><ETLBatchID>' + 
ISNULL(CAST(@ETLBatchID AS varchar), '') + '</ETLBatchID><ExcludeFromFacilityDirectoryFlag>' + 
ISNULL(CAST(@ExcludeFromFacilityDirectoryFlag AS varchar), '') + '</ExcludeFromFacilityDirectoryFlag><Gender>' + ISNULL(CAST(@Gender AS varchar), '') +
 '</Gender><GISAddressType>' + ISNULL(CAST(@GISAddressType AS varchar), '') + '</GISAddressType><GISAddressUpdatedDate>' +
 ISNULL(CAST(@GISAddressUpdatedDate AS varchar), '') +
 '</GISAddressUpdatedDate><GISCongressDistrict>' + ISNULL(CAST(@GISCongressDistrict AS varchar), '') +
  '</GISCongressDistrict><GISFIPSCode>' + ISNULL(CAST(@GISFIPSCode AS varchar), '') + '</GISFIPSCode><GISLocatorName>' + ISNULL(CAST(@GISLocatorName AS varchar), '') + 
 '</GISLocatorName><GISMarket>' + ISNULL(CAST(@GISMarket AS varchar), '') + '</GISMarket><GISMatchedAddress>' +
  ISNULL(CAST(@GISMatchedAddress AS varchar), '') + '</GISMatchedAddress><GISMatchMethodCode>' +
   ISNULL(CAST(@GISMatchMethodCode AS varchar), '') +
  '</GISMatchMethodCode><GISMatchScore>' + ISNULL(CAST(@GISMatchScore AS varchar), '') +
   '</GISMatchScore><GISMatchStatusCode>' + ISNULL(CAST(@GISMatchStatusCode AS varchar), '') + 
   '</GISMatchStatusCode><GISPatientAddressLatitude>' + 
ISNULL(CAST(@GISPatientAddressLatitude AS varchar), '') + '</GISPatientAddressLatitude><GISPatientAddressLongitude>' + 
ISNULL(CAST(@GISPatientAddressLongitude AS varchar), '') + '</GISPatientAddressLongitude><GISSector>' + ISNULL(CAST(@GISSector AS varchar), '') +
 '</GISSector><GISStreetSide>' + ISNULL(CAST(@GISStreetSide AS varchar), '') + '</GISStreetSide><GISSubmarket>' +
  ISNULL(CAST(@GISSubmarket AS varchar), '') + '</GISSubmarket><GISURH>' + ISNULL(CAST(@GISURH AS varchar), '') +
   '</GISURH><InsuranceCoverageFlag>' + ISNULL(CAST(@InsuranceCoverageFlag AS varchar), '') + '</InsuranceCoverageFlag><LastServiceEntryDate>' +
    ISNULL(CAST(@LastServiceEntryDate AS varchar), '') + '</LastServiceEntryDate><LastServiceEntryDateTransformSID>' + 
   ISNULL(CAST(@LastServiceEntryDateTransformSID AS varchar), '') + 
 '</LastServiceEntryDateTransformSID><LastServiceEntryVistaErrorDate>' + ISNULL(CAST(@LastServiceEntryVistaErrorDate AS varchar), '') +
  '</LastServiceEntryVistaErrorDate><LastServiceSeparationDate>
' + ISNULL(CAST(@LastServiceSeparationDate AS varchar), '') + '</LastServiceSeparationDate><LastServiceSeparationDateTransformSID>' +
 ISNULL(CAST(@LastServiceSeparationDateTransformSID AS varchar), '') + '</LastServiceSeparationDateTransformSID><LastServiceSeparationVistaErrorDate>' + 
ISNULL(CAST(@LastServiceSeparationVistaErrorDate AS varchar), '') + '</LastServiceSeparationVistaErrorDate><MaritalStatus>' + 
ISNULL(CAST(@MaritalStatus AS varchar), '') + '</MaritalStatus><MaritalStatusIEN>' + ISNULL(CAST(@MaritalStatusIEN AS varchar), '') + 
'</MaritalStatusIEN><MaritalStatusSID>' + ISNULL(CAST(@MaritalStatusSID AS varchar), '') + '</MaritalStatusSID><MedicaidNumber>' + 
ISNULL(CAST(@MedicaidNumber AS varchar), '') + '</MedicaidNumber><MothersMaidenName>' + 
ISNULL(CAST(@MothersMaidenName AS varchar), '') + '</MothersMaidenName><OEF_OIF_IND>' + ISNULL(CAST(@OEF_OIF_IND AS varchar), '') +
 '</OEF_OIF_IND><OpCode>' + ISNULL(CAST(@OpCode AS varchar), '') + '</OpCode><Patient_ID>' + ISNULL(CAST(@Patient_ID AS varchar), '') +
 '</Patient_ID><PatientFirstName>' + ISNULL(CAST(@PatientFirstName AS varchar), '') + '</PatientFirstName><PatientICN>' + 
 ISNULL(CAST(@PatientICN AS varchar), '') + '</PatientICN><PatientICNChecksum>' + ISNULL(CAST(@PatientICNChecksum AS varchar), '') +
 '</PatientICNChecksum><PatientIEN>' + ISNULL(CAST(@PatientIEN AS varchar), '') + '</PatientIEN><PatientLastName>' + 
 ISNULL(CAST(@PatientLastName AS varchar), '') + '</PatientLastName><PatientName>' + ISNULL(CAST(@PatientName AS varchar), '') + '
</PatientName><PatientSID>' + ISNULL(CAST(@PatientSID AS varchar), '') + '</PatientSID><PatientSSN>' + ISNULL(CAST(@PatientSSN AS varchar), '') +
 '</PatientSSN><PercentServiceConnect>' + ISNULL(CAST(@PercentServiceConnect AS varchar), '') + '</PercentServ
iceConnect><PeriodOfService>' + ISNULL(CAST(@PeriodOfService AS varchar), '') + '</PeriodOfService><PeriodOfServiceIEN>' + 
ISNULL(CAST(@PeriodOfServiceIEN AS varchar), '') + '</PeriodOfServiceIEN><PeriodOfServiceSID>' + ISNULL(CAST(@PeriodOfServiceSID AS 
varchar), '') + '</PeriodOfServiceSID><PhoneCellular>' + ISNULL(CAST(@PhoneCellular AS varchar), '') + 
'</PhoneCellular><PhoneResidence>' + ISNULL(CAST(@PhoneResidence AS varchar), '') + '</PhoneResidence><PhoneWork>' +
 ISNULL(CAST(@PhoneWork AS varchar),
 '') + '</PhoneWork><PK_ID>' + ISNULL(CAST(@PK_ID AS varchar), '') + '</PK_ID><PostalCode>' + 
 ISNULL(CAST(@PostalCode AS varchar), CAST(@zip AS varchar)) + '</PostalCode><POWLocationIEN>' + ISNULL(CAST(@POWLocationIEN AS varchar), '') + '</POWLocationIEN><PreferredInstituti
onIEN>' + ISNULL(CAST(@PreferredInstitutionIEN AS varchar), '') + '</PreferredInstitutionIEN><Province>' + 
ISNULL(CAST(@Province AS varchar), '') + '</Province><PseudoSSNFlag>' + ISNULL(CAST(@PseudoSSNFlag AS varchar), '') + 
'</PseudoSSNFlag><PurpleHeartI
nstitutionIEN>' + ISNULL(CAST(@PurpleHeartInstitutionIEN AS varchar), '') + '</PurpleHeartInstitutionIEN><Race>' + 
ISNULL(CAST(@Race AS varchar), '') + '</Race><RaceIEN>' + ISNULL(CAST(@RaceIEN AS varchar), '') + '</RaceIEN><RaceSID>' + 
ISNULL(CAST(@RaceSID AS varchar), '') + 
'</RaceSID><Religion>' + ISNULL(CAST(@Religion AS varchar), '') + '</Religion><ReligionIEN>' + ISNULL(CAST(@ReligionIEN AS varchar), '') +
 '</ReligionIEN><ReligionSID>' + ISNULL(CAST(@ReligionSID AS varchar), '') + 
'</ReligionSID><RoomBedIEN>' + ISNULL(CAST(@RoomBedIEN AS varchar), '') + '</RoomBedIEN><ScrSSN>' + ISNULL(CAST(@ScrSSN AS varchar), '') + 
'</ScrSSN><SensitiveFlag>' + ISNULL(CAST(@SensitiveFlag AS varchar), '') + '</SensitiveFlag><Sta3n>' + ISNULL(CAST(@Sta3n AS varchar),
 '') + '</Sta3n><State>' + ISNULL(CAST(@State AS varchar), '') + '</State><StateIEN>' + ISNULL(CAST(@StateIEN AS varchar), '') + 
 '</StateIEN><StateSID>' + ISNULL(CAST(@StateSID AS varchar), '') + '</StateSID><STD_COMBATLOCATION_ID>' + ISNULL(CAST(@STD_COMBATLOCATION_ID AS varchar), '') + 
 '</STD_COMBATLOCATION_ID><STD_ENTHNICITY_ID>' + ISNULL(CAST(@STD_ENTHNICITY_ID AS varchar), '') + '</STD_ENTHNICITY_ID><STD_GENDER_ID>' +
  ISNULL(CAST(@STD_GENDER_ID AS varchar), '') + '</STD_GENDER_ID><STD_MARITALSTATUS_ID>' +
  ISNULL(CAST(@STD_MARITALSTATUS_ID AS varchar), '') + '</STD_MARITALSTATUS_ID><STD_RACE_ID>' + ISNULL(CAST(@STD_RACE_ID AS varchar), '') + 
  '</STD_RACE_ID><STD_SERVICEBRANCH_ID>' + ISNULL(CAST(@STD_SERVICEBRANCH_ID AS varchar), '') + '</STD_SERVICEBRANCH_ID><StdRegistryId>' + 
  ISNULL(CAST(@StdRegistryId AS varchar), '') + 
  '</StdRegistryId><StreetAddress1>' + ISNULL(CAST(@StreetAddress1 AS varchar), '') +
 '</StreetAddress1><StreetAddress2>' + ISNULL(CAST(@StreetAddress2 AS varchar), '') + '</StreetAddress2><StreetAddress3>' +
  ISNULL(CAST(@StreetAddress3 AS varchar), '') + '</StreetAddress3><TemporaryAddressChangeInstitutionIEN>' + ISNULL(CAST(@TemporaryAddressChangeInstitutionIEN AS varchar), '') +
   '</TemporaryAddressChangeInstitutionIEN><Updatedate>' +
 ISNULL(CAST(@Updatedate AS varchar), '') + '</Updatedate><UpdatedBy>' + ISNULL(CAST(@UpdatedBy AS varchar), '') +
  '</UpdatedBy><VeteranFlag>' + ISNULL(CAST(@VeteranFlag AS varchar), '') + '</VeteranFlag><VistaCreateDate>' + 
 ISNULL(CAST(@VistaCreateDate AS varchar), '') + '</VistaCreateDate><VistaEditDate>' + ISNULL(CAST(@VistaEditDate AS varchar), '') +
  '</VistaEditDate><Zip>' + ISNULL(CAST(@zip AS varchar), CAST(@PostalCode AS varchar))+ '</Zip><Zip4>' +
   ISNULL(CAST(@Zip4 AS varchar), '') + '</Zip4>';
			SELECT @ErrorMsg = '[CRS].[SPATIENT] values have been updated (Old Values:' + @OldValues + ') to (New Values:' + @NewValues + ') by (' + @CURRENT_USER + ')';
			EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_SPATIENT_save', @ErrorMsg, NULL, @CURRENT_USER;

			-- if insert then set UPDATED to current date time
			SET @Updatedate = GetDate();
			UPDATE [CRS].[SPATIENT] 
			SET
				[AddressChangeInstitutionIEN] = @AddressChangeInstitutionIEN
				, [AddressChangeInstitutionSID] = @AddressChangeInstitutionSID
				, [AddressChangeStaffIEN] = @AddressChangeStaffIEN
				, [AddressChangeStaffSID] = @AddressChangeStaffSID
				, [Age] = @Age
				, [BadAddressIndicator] = @BadAddressIndicator
				, [CDDeterminingInstitutionIEN] = @CDDeterminingInstitutionIEN
				, [City] = @City
				, [CombatFromVistaDate] = @CombatFromVistaDate
				, [CombatToVistaDate] = @CombatToVistaDate
				, [ConfidentialAddressActiveFlag] = @ConfidentialAddressActiveFlag
				, [Country] = @Country
				, [CountryIEN] = @CountryIEN
				, [CountrySID] = @CountrySID
				, [County] = @County
				, [Created] = @Created
				, [CreatedBy] = @CreatedBy
				, [CurrentMeansTestStatusIEN] = @CurrentMeansTestStatusIEN
				, [DateOfBirth] = @DateOfBirth
				, [DateOfBirthText] = @DateOfBirthText
				, [DateOfDeath] = @DateOfDeath
				, [DateOfDeathText] = @DateOfDeathText
				, [Deceased] = @Deceased
				, [DEFAULT_RECORD] = @DEFAULT_RECORD
				, [Eligibility] = @Eligibility
				, [EligibilityIEN] = @EligibilityIEN
				, [EligibilitySID] = @EligibilitySID
				, [EligibilityStatus] = @EligibilityStatus
				, [EligibilityVACode] = @EligibilityVACode
				, [EligibilityVerificationSource] = @EligibilityVerificationSource
				, [EmailAddress] = @EmailAddress
				, [EnteredIntoFileDate] = @EnteredIntoFileDate
				, [EnteredIntoFileDateTransformSID] = @EnteredIntoFileDateTransformSID
				, [EnteredIntoFileVistaErrorDate] = @EnteredIntoFileVistaErrorDate
				, [ETLBatchID] = @ETLBatchID
				, [ExcludeFromFacilityDirectoryFlag] = @ExcludeFromFacilityDirectoryFlag
				, [Gender] = @Gender
				, [GISAddressType] = @GISAddressType
				, [GISAddressUpdatedDate] = @GISAddressUpdatedDate
				, [GISCongressDistrict] = @GISCongressDistrict
				, [GISFIPSCode] = @GISFIPSCode
				, [GISLocatorName] = @GISLocatorName
				, [GISMarket] = @GISMarket
				, [GISMatchedAddress] = @GISMatchedAddress
				, [GISMatchMethodCode] = @GISMatchMethodCode
				, [GISMatchScore] = @GISMatchScore
				, [GISMatchStatusCode] = @GISMatchStatusCode
				, [GISPatientAddressLatitude] = @GISPatientAddressLatitude
				, [GISPatientAddressLongitude] = @GISPatientAddressLongitude
				, [GISSector] = @GISSector
				, [GISStreetSide] = @GISStreetSide
				, [GISSubmarket] = @GISSubmarket
				, [GISURH] = @GISURH
				, [InsuranceCoverageFlag] = @InsuranceCoverageFlag
				, [LastServiceEntryDate] = @LastServiceEntryDate
				, [LastServiceEntryDateTransformSID] = @LastServiceEntryDateTransformSID
				, [LastServiceEntryVistaErrorDate] = @LastServiceEntryVistaErrorDate
				, [LastServiceSeparationDate] = @LastServiceSeparationDate
				, [LastServiceSeparationDateTransformSID] = @LastServiceSeparationDateTransformSID
				, [LastServiceSeparationVistaErrorDate] = @LastServiceSeparationVistaErrorDate
				, [MaritalStatus] = @MaritalStatus
				, [MaritalStatusIEN] = @MaritalStatusIEN
				, [MaritalStatusSID] = @MaritalStatusSID
				, [MedicaidNumber] = @MedicaidNumber
				, [MothersMaidenName] = @MothersMaidenName
				, [OEF_OIF_IND] = @OEF_OIF_IND
				, [OpCode] = @OpCode
				, [Patient_ID] = @Patient_ID
				, [PatientFirstName] = @PatientFirstName
				, [PatientICN] = @PatientICN
				, [PatientICNChecksum] = @PatientICNChecksum
				, [PatientIEN] = @PatientIEN
				, [PatientLastName] = @PatientLastName
				, [PatientName] = @PatientName
				, [PatientSID] = @PatientSID
				, [PatientSSN] = @PatientSSN
				, [PercentServiceConnect] = @PercentServiceConnect
				, [PeriodOfService] = @PeriodOfService
				, [PeriodOfServiceIEN] = @PeriodOfServiceIEN
				, [PeriodOfServiceSID] = @PeriodOfServiceSID
				, [PhoneCellular] = @PhoneCellular
				, [PhoneResidence] = @PhoneResidence
				, [PhoneWork] = @PhoneWork
				, [PostalCode] = ISNULL(@PostalCode,@Zip)
				, [POWLocationIEN] = @POWLocationIEN
				, [PreferredInstitutionIEN] = @PreferredInstitutionIEN
				, [Province] = @Province
				, [PseudoSSNFlag] = @PseudoSSNFlag
				, [PurpleHeartInstitutionIEN] = @PurpleHeartInstitutionIEN
				, [Race] = @Race
				, [RaceIEN] = @RaceIEN
				, [RaceSID] = @RaceSID
				, [Religion] = @Religion
				, [ReligionIEN] = @ReligionIEN
				, [ReligionSID] = @ReligionSID
				, [RoomBedIEN] = @RoomBedIEN
				, [ScrSSN] = @ScrSSN
				, [SensitiveFlag] = @SensitiveFlag
				, [Sta3n] = @Sta3n
				, [State] = @State
				, [StateIEN] = @StateIEN
				, [StateSID] = @StateSID
				, [STD_COMBATLOCATION_ID] = @STD_COMBATLOCATION_ID
				, [STD_ENTHNICITY_ID] = @STD_ENTHNICITY_ID
				, [STD_GENDER_ID] = @STD_GENDER_ID
				, [STD_MARITALSTATUS_ID] = @STD_MARITALSTATUS_ID
				, [STD_RACE_ID] = @STD_RACE_ID
				, [STD_SERVICEBRANCH_ID] = @STD_SERVICEBRANCH_ID
				, [StdRegistryId] = @StdRegistryId
				, [StreetAddress1] = @StreetAddress1
				, [StreetAddress2] = @StreetAddress2
				, [StreetAddress3] = @StreetAddress3
				, [TemporaryAddressChangeInstitutionIEN] = @TemporaryAddressChangeInstitutionIEN
				, [Updatedate] = @Updatedate
				, [UpdatedBy] = @UpdatedBy
				, [VeteranFlag] = @VeteranFlag
				, [VistaCreateDate] = @VistaCreateDate
				, [VistaEditDate] = @VistaEditDate
				, [Zip] = ISNULL(@Zip,@PostalCode)
				, [Zip4] = @Zip4
			WHERE
				[PK_ID] = @PK_ID;
		END
END


